/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import java.lang.reflect.Array;
import java.util.List;

public final class Arrays {
    private Arrays() {
    }

    public static <T> int length(T[] a2) {
        return a2 == null ? 0 : a2.length;
    }

    public static <T> List<T> asList(T[] a2) {
        return Objects.isEmpty(a2) ? Collections.emptyList() : java.util.Arrays.asList(a2);
    }

    public static int length(byte[] bytes) {
        return bytes != null ? bytes.length : 0;
    }

    public static byte[] clean(byte[] bytes) {
        return (byte[])(Arrays.length(bytes) > 0 ? bytes : null);
    }

    public static Object copy(Object obj) {
        if (obj == null) {
            return null;
        }
        Assert.isTrue(Objects.isArray(obj), "Argument must be an array.");
        if (obj instanceof Object[]) {
            return ((Object[])obj).clone();
        }
        if (obj instanceof boolean[]) {
            return ((boolean[])obj).clone();
        }
        if (obj instanceof byte[]) {
            return ((byte[])obj).clone();
        }
        if (obj instanceof char[]) {
            return ((char[])obj).clone();
        }
        if (obj instanceof double[]) {
            return ((double[])obj).clone();
        }
        if (obj instanceof float[]) {
            return ((float[])obj).clone();
        }
        if (obj instanceof int[]) {
            return ((int[])obj).clone();
        }
        if (obj instanceof long[]) {
            return ((long[])obj).clone();
        }
        if (obj instanceof short[]) {
            return ((short[])obj).clone();
        }
        Class<?> componentType = obj.getClass().getComponentType();
        int length = Array.getLength(obj);
        Object[] copy = (Object[])Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            copy[i] = Array.get(obj, i);
        }
        return copy;
    }
}

