/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.foliascheduler.reflectionremapper;

import com.cjcrafter.foliascheduler.mappingio.MappingReader;
import com.cjcrafter.foliascheduler.mappingio.MappingVisitor;
import com.cjcrafter.foliascheduler.mappingio.tree.MemoryMappingTree;
import com.cjcrafter.foliascheduler.reflectionremapper.ClassNamePreprocessingReflectionRemapper;
import com.cjcrafter.foliascheduler.reflectionremapper.NoopReflectionRemapper;
import com.cjcrafter.foliascheduler.reflectionremapper.ReflectionRemapperImpl;
import com.cjcrafter.foliascheduler.reflectionremapper.internal.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public interface ReflectionRemapper {
    public String remapClassName(String var1);

    public String remapFieldName(Class<?> var1, String var2);

    public String remapMethodName(Class<?> var1, String var2, Class<?> ... var3);

    default public String remapClassOrArrayName(String name) {
        Objects.requireNonNull(name, "name");
        if (name.isEmpty()) {
            return name;
        }
        if (name.charAt(0) == '[') {
            int last = name.lastIndexOf(91);
            try {
                if (name.charAt(last + 1) == 'L') {
                    String cls = name.substring(last + 2, name.length() - 1);
                    return name.substring(0, last + 2) + this.remapClassName(cls) + ';';
                }
            }
            catch (IndexOutOfBoundsException ex) {
                return name;
            }
            return name;
        }
        return this.remapClassName(name);
    }

    default public ReflectionRemapper withClassNamePreprocessor(UnaryOperator<String> preprocessor) {
        return new ClassNamePreprocessingReflectionRemapper(this, preprocessor);
    }

    public static ReflectionRemapper noop() {
        return NoopReflectionRemapper.INSTANCE;
    }

    public static ReflectionRemapper forMappings(InputStream mappings, String fromNamespace, String toNamespace) {
        try {
            MemoryMappingTree tree = new MemoryMappingTree(true);
            tree.setSrcNamespace(fromNamespace);
            tree.setDstNamespaces(new ArrayList<String>(Collections.singletonList(toNamespace)));
            MappingReader.read(new InputStreamReader(mappings, StandardCharsets.UTF_8), (MappingVisitor)tree);
            return ReflectionRemapperImpl.fromMappingTree(tree, fromNamespace, toNamespace);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read mappings.", ex);
        }
    }

    public static ReflectionRemapper forMappings(Path mappings, String fromNamespace, String toNamespace) {
        ReflectionRemapper reflectionRemapper;
        block8: {
            InputStream stream = Files.newInputStream(mappings, new OpenOption[0]);
            try {
                reflectionRemapper = ReflectionRemapper.forMappings(stream, fromNamespace, toNamespace);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return reflectionRemapper;
    }

    public static ReflectionRemapper forPaperReobfMappings(Path mappings) {
        ReflectionRemapper reflectionRemapper;
        block9: {
            if (Util.mojangMapped()) {
                return ReflectionRemapper.noop();
            }
            InputStream inputStream = Files.newInputStream(mappings, new OpenOption[0]);
            try {
                reflectionRemapper = ReflectionRemapper.forPaperReobfMappings(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read mappings.", e);
                }
            }
            inputStream.close();
        }
        return reflectionRemapper;
    }

    public static ReflectionRemapper forPaperReobfMappings(InputStream mappings) {
        if (Util.mojangMapped()) {
            return ReflectionRemapper.noop();
        }
        if (Util.firstLine(mappings).contains("mojang+yarn")) {
            return ReflectionRemapper.forMappings(mappings, "mojang+yarn", "spigot");
        }
        return ReflectionRemapper.forMappings(mappings, "mojang", "spigot");
    }

    public static ReflectionRemapper forReobfMappingsInPaperJar() {
        ReflectionRemapper reflectionRemapper;
        block12: {
            Class<?> craftServerClass;
            if (Util.mojangMapped()) {
                return ReflectionRemapper.noop();
            }
            try {
                Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit");
                Method getServerMethod = bukkitClass.getDeclaredMethod("getServer", new Class[0]);
                craftServerClass = getServerMethod.invoke(null, new Object[0]).getClass();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            @Nullable InputStream reobfIn = craftServerClass.getClassLoader().getResourceAsStream("META-INF/mappings/reobf.tiny");
            try {
                if (reobfIn == null) {
                    throw new IllegalStateException("Could not find mappings in expected location.");
                }
                reflectionRemapper = ReflectionRemapper.forPaperReobfMappings(reobfIn);
                if (reobfIn == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (reobfIn != null) {
                        try {
                            reobfIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reobfIn.close();
        }
        return reflectionRemapper;
    }
}

