/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.commandapi;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.objz.commandbridge.commandapi.CommandAPI;
import dev.objz.commandbridge.commandapi.CommandAPIExecutor;
import dev.objz.commandbridge.commandapi.CommandAPIPlatform;
import dev.objz.commandbridge.commandapi.CommandMetaData;
import dev.objz.commandbridge.commandapi.CommandPermission;
import dev.objz.commandbridge.commandapi.RegisteredCommand;
import dev.objz.commandbridge.commandapi.SafeVarHandle;
import dev.objz.commandbridge.commandapi.SuggestionInfo;
import dev.objz.commandbridge.commandapi.arguments.AbstractArgument;
import dev.objz.commandbridge.commandapi.arguments.ArgumentSuggestions;
import dev.objz.commandbridge.commandapi.arguments.CustomProvidedArgument;
import dev.objz.commandbridge.commandapi.arguments.Literal;
import dev.objz.commandbridge.commandapi.arguments.MultiLiteral;
import dev.objz.commandbridge.commandapi.commandsenders.AbstractCommandSender;
import dev.objz.commandbridge.commandapi.executors.CommandArguments;
import dev.objz.commandbridge.commandapi.executors.ExecutionInfo;
import dev.objz.commandbridge.commandapi.network.CommandAPIMessenger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class CommandAPIHandler<Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender, Source> {
    private static final SafeVarHandle<CommandContext<?>, Map<String, ParsedArgument<?, ?>>> commandContextArguments = SafeVarHandle.ofOrNull(CommandContext.class, "arguments", "arguments", Map.class);
    private static final Map<ClassCache, Field> FIELDS = new HashMap<ClassCache, Field>();
    final CommandAPIPlatform<Argument, CommandSender, Source> platform;
    private CommandAPIMessenger<?, ?> messenger;
    final TreeMap<String, CommandPermission> registeredPermissions = new TreeMap();
    final List<RegisteredCommand> registeredCommands;
    static final Pattern NAMESPACE_PATTERN = Pattern.compile("[0-9a-z_.-]+");
    private static CommandAPIHandler<?, ?, ?> instance;

    public static <CommandSource> String getRawArgumentInput(CommandContext<CommandSource> cmdCtx, String key) {
        ParsedArgument<?, ?> parsedArgument = commandContextArguments.get(cmdCtx).get(key);
        if (parsedArgument != null) {
            StringRange range = parsedArgument.getRange();
            if (range.getEnd() > cmdCtx.getInput().length()) {
                range = StringRange.between((int)range.getStart(), (int)cmdCtx.getInput().length());
            }
            return range.get(cmdCtx.getInput());
        }
        return "";
    }

    protected CommandAPIHandler(CommandAPIPlatform<Argument, CommandSender, Source> platform) {
        this.platform = platform;
        this.registeredCommands = new ArrayList<RegisteredCommand>();
        instance = this;
    }

    public void onLoad() {
        this.checkDependencies();
        this.platform.onLoad();
    }

    private void checkDependencies() {
        try {
            Class.forName("com.mojang.brigadier.CommandDispatcher");
        }
        catch (ClassNotFoundException e) {
            new ClassNotFoundException("Could not hook into Brigadier (Are you running Minecraft 1.13 or above?)").printStackTrace();
        }
    }

    public void onEnable() {
        this.platform.onEnable();
        this.messenger = this.platform.setupMessenger();
    }

    public void onDisable() {
        this.messenger.close();
        this.platform.onDisable();
        CommandAPIHandler.resetInstance();
    }

    private static void resetInstance() {
        instance = null;
    }

    public static CommandAPIHandler<?, ?, ?> getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("Tried to access CommandAPIHandler instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public CommandAPIPlatform<Argument, CommandSender, Source> getPlatform() {
        return this.platform;
    }

    public Command<Source> generateCommand(Argument[] args, CommandAPIExecutor<CommandSender, AbstractCommandSender<? extends CommandSender>> executor, boolean converted) {
        return cmdCtx -> {
            final AbstractCommandSender<CommandSender> sender = this.platform.getSenderForCommand(cmdCtx, executor.isForceNative());
            final CommandArguments commandArguments = this.argsToCommandArgs(cmdCtx, (AbstractArgument[])args);
            ExecutionInfo executionInfo = new ExecutionInfo<CommandSender, AbstractCommandSender<? extends CommandSender>>(this){
                final /* synthetic */ CommandAPIHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public CommandSender sender() {
                    return sender.getSource();
                }

                @Override
                public AbstractCommandSender<? extends CommandSender> senderWrapper() {
                    return sender;
                }

                @Override
                public CommandArguments args() {
                    return commandArguments;
                }
            };
            if (converted) {
                int resultValue = 0;
                String[] argsAndCmd = cmdCtx.getRange().get(cmdCtx.getInput()).split(" ");
                final String[] result = new String[argsAndCmd.length - 1];
                ExecutionInfo convertedExecutionInfo = new ExecutionInfo<CommandSender, AbstractCommandSender<? extends CommandSender>>(this){
                    final /* synthetic */ CommandAPIHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public CommandSender sender() {
                        return sender.getSource();
                    }

                    @Override
                    public AbstractCommandSender<? extends CommandSender> senderWrapper() {
                        return sender;
                    }

                    @Override
                    public CommandArguments args() {
                        return new CommandArguments(result, new LinkedHashMap<String, Object>(), result, new LinkedHashMap<String, String>(), "/" + cmdCtx.getInput());
                    }
                };
                System.arraycopy(argsAndCmd, 1, result, 0, argsAndCmd.length - 1);
                List[] entityNamesForArgs = new List[args.length];
                for (int i = 0; i < args.length; ++i) {
                    entityNamesForArgs[i] = args[i].getEntityNames(commandArguments.get(i));
                }
                List product = CartesianProduct.getDescartes(Arrays.asList(entityNamesForArgs));
                for (List strings : product) {
                    if (result.length == strings.size()) {
                        for (int i = 0; i < result.length; ++i) {
                            if (strings.get(i) == null) continue;
                            result[i] = (String)strings.get(i);
                        }
                    }
                    resultValue += executor.execute(convertedExecutionInfo);
                }
                return resultValue;
            }
            return executor.execute(executionInfo);
        };
    }

    CommandArguments argsToCommandArgs(CommandContext<Source> cmdCtx, Argument[] args) throws CommandSyntaxException {
        ArrayList<Object> argList = new ArrayList<Object>();
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>();
        ArrayList<String> rawArguments = new ArrayList<String>();
        LinkedHashMap<String, String> rawArgumentsMap = new LinkedHashMap<String, String>();
        for (Argument argument : args) {
            if (!((AbstractArgument)argument).isListed()) continue;
            Object parsedArgument = this.parseArgument(cmdCtx, ((AbstractArgument)argument).getNodeName(), argument, new CommandArguments(argList.toArray(), argsMap, rawArguments.toArray(new String[0]), rawArgumentsMap, "/" + cmdCtx.getInput()));
            argList.add(parsedArgument);
            argsMap.put(((AbstractArgument)argument).getNodeName(), parsedArgument);
            String rawArgumentString = CommandAPIHandler.getRawArgumentInput(cmdCtx, ((AbstractArgument)argument).getNodeName());
            rawArguments.add(rawArgumentString);
            rawArgumentsMap.put(((AbstractArgument)argument).getNodeName(), rawArgumentString);
        }
        return new CommandArguments(argList.toArray(), argsMap, rawArguments.toArray(new String[0]), rawArgumentsMap, "/" + cmdCtx.getInput());
    }

    Object parseArgument(CommandContext<Source> cmdCtx, String key, Argument value, CommandArguments previousArgs) throws CommandSyntaxException {
        if (((AbstractArgument)value).isListed()) {
            return ((AbstractArgument)value).parseArgument(cmdCtx, key, previousArgs);
        }
        return null;
    }

    Predicate<Source> generatePermissions(String commandName, CommandPermission permission, Predicate<CommandSender> requirements, String namespace) {
        String namespacedCommand;
        String string = namespacedCommand = namespace.isEmpty() ? commandName.toLowerCase() : namespace.toLowerCase() + ":" + commandName.toLowerCase();
        if (this.registeredPermissions.containsKey(namespacedCommand)) {
            permission = this.registeredPermissions.get(namespacedCommand);
        } else {
            this.registeredPermissions.put(namespacedCommand, permission);
            this.registeredPermissions.putIfAbsent(commandName.toLowerCase(), permission);
        }
        permission.getPermission().ifPresent(this.platform::registerPermission);
        CommandPermission finalPermission = permission;
        return css -> CommandAPIHandler.permissionCheck(this.platform.getCommandSenderFromCommandSource(css), finalPermission, requirements);
    }

    static <CommandSender> boolean permissionCheck(AbstractCommandSender<? extends CommandSender> sender, CommandPermission permission, Predicate<CommandSender> requirements) {
        Optional<String> optionalPerm;
        if (sender == null) {
            return true;
        }
        boolean satisfiesPermissions = permission.equals(CommandPermission.NONE) ? true : (permission.equals(CommandPermission.OP) ? sender.isOp() : ((optionalPerm = permission.getPermission()).isPresent() ? sender.hasPermission(optionalPerm.get()) : true));
        if (permission.isNegated()) {
            satisfiesPermissions = !satisfiesPermissions;
        }
        return satisfiesPermissions && requirements.test(sender.getSource());
    }

    private boolean expandMultiLiterals(CommandMetaData<CommandSender> meta, Argument[] args, CommandAPIExecutor<CommandSender, AbstractCommandSender<? extends CommandSender>> executor, boolean converted, String namespace) {
        for (int index = 0; index < args.length; ++index) {
            if (!(args[index] instanceof MultiLiteral)) continue;
            MultiLiteral superArg = (MultiLiteral)args[index];
            String nodeName = ((AbstractArgument)superArg.instance()).getNodeName();
            for (String literal : superArg.getLiterals()) {
                Argument litArg = this.platform.newConcreteLiteralArgument(nodeName == null ? literal : nodeName, literal);
                ((AbstractArgument)((AbstractArgument)((AbstractArgument)litArg).setListed(((AbstractArgument)superArg.instance()).isListed())).withPermission(((AbstractArgument)superArg.instance()).getArgumentPermission())).withRequirement(((AbstractArgument)superArg.instance()).getRequirements());
                AbstractArgument[] newArgs = (AbstractArgument[])Arrays.copyOf(args, args.length);
                newArgs[index] = litArg;
                this.register(meta, newArgs, executor, converted, namespace);
            }
            return true;
        }
        return false;
    }

    private boolean hasCommandConflict(String commandName, Argument[] args, String argumentsAsString) {
        ArrayList<String[]> regArgs = new ArrayList<String[]>();
        for (RegisteredCommand rCommand : this.registeredCommands) {
            if (!rCommand.commandName().equals(commandName)) continue;
            for (String str : rCommand.argsAsStr()) {
                regArgs.add(str.split(":"));
            }
        }
        for (int i = 0; i < args.length && (regArgs.size() != i || regArgs.size() >= args.length) && ((String[])regArgs.get(i))[0].equals(((AbstractArgument)args[i]).getNodeName()); ++i) {
            if (i != args.length - 1 || ((String[])regArgs.get(i))[1].equals(args[i].getClass().getSimpleName())) continue;
            StringBuilder builder2 = new StringBuilder();
            for (String[] arg : regArgs) {
                builder2.append(arg[0]).append("<").append(arg[1]).append("> ");
            }
            CommandAPI.logError("Failed to register command:\n\n  %s %s\n\nBecause it conflicts with this previously registered command:\n\n  %s %s\n".formatted(commandName, argumentsAsString, commandName, builder2.toString()));
            return true;
        }
        return false;
    }

    private ArgumentBuilder<Source, ?> generateInnerArgument(Command<Source> command, Argument[] args) {
        Argument innerArg = args[args.length - 1];
        if (innerArg instanceof Literal) {
            Literal literalArgument = (Literal)innerArg;
            return this.getLiteralArgumentBuilderArgument(literalArgument.getLiteral(), ((AbstractArgument)innerArg).getArgumentPermission(), ((AbstractArgument)innerArg).getRequirements()).executes(command);
        }
        if (innerArg instanceof CustomProvidedArgument) {
            CustomProvidedArgument customProvidedArg = (CustomProvidedArgument)innerArg;
            if (((AbstractArgument)innerArg).getOverriddenSuggestions().isEmpty()) {
                return this.getRequiredArgumentBuilderWithProvider((AbstractArgument)innerArg, (AbstractArgument[])args, (SuggestionProvider)this.platform.getSuggestionProvider(customProvidedArg.getSuggestionProvider())).executes(command);
            }
        }
        return this.getRequiredArgumentBuilderDynamic((AbstractArgument[])args, (AbstractArgument)innerArg).executes(command);
    }

    private ArgumentBuilder<Source, ?> generateOuterArguments(ArgumentBuilder<Source, ?> innermostArgument, Argument[] args) {
        ArgumentBuilder outer = innermostArgument;
        for (int i = args.length - 2; i >= 0; --i) {
            Argument outerArg = args[i];
            if (outerArg instanceof Literal) {
                Literal literalArgument = (Literal)outerArg;
                outer = this.getLiteralArgumentBuilderArgument(literalArgument.getLiteral(), ((AbstractArgument)outerArg).getArgumentPermission(), ((AbstractArgument)outerArg).getRequirements()).then(outer);
                continue;
            }
            if (outerArg instanceof CustomProvidedArgument) {
                CustomProvidedArgument customProvidedArg = (CustomProvidedArgument)outerArg;
                if (((AbstractArgument)outerArg).getOverriddenSuggestions().isEmpty()) {
                    outer = this.getRequiredArgumentBuilderWithProvider((AbstractArgument)outerArg, (AbstractArgument[])args, (SuggestionProvider)this.platform.getSuggestionProvider(customProvidedArg.getSuggestionProvider())).then(outer);
                    continue;
                }
            }
            outer = this.getRequiredArgumentBuilderDynamic((AbstractArgument[])args, (AbstractArgument)outerArg).then(outer);
        }
        return outer;
    }

    void register(CommandMetaData<CommandSender> meta, Argument[] args, CommandAPIExecutor<CommandSender, AbstractCommandSender<? extends CommandSender>> executor, boolean converted, String namespace) {
        LiteralCommandNode<Source> resultantNode;
        if (this.expandMultiLiterals(meta, (AbstractArgument[])args, executor, converted, namespace)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Argument arg : args) {
            builder.append(((AbstractArgument)arg).toString()).append(" ");
        }
        String humanReadableCommandArgSyntax = builder.toString().trim();
        if (!this.checkForDuplicateArgumentNodeNames((AbstractArgument[])args, humanReadableCommandArgSyntax, meta.commandName)) {
            return;
        }
        String commandName = meta.commandName;
        CommandPermission permission = meta.permission;
        String[] aliases = meta.aliases;
        Predicate requirements = meta.requirements;
        Optional<String> shortDescription = meta.shortDescription;
        Optional<String> fullDescription = meta.fullDescription;
        Optional<String[]> usageDescription = meta.usageDescription;
        Optional<Object> helpTopic = meta.helpTopic;
        boolean hasRegisteredCommand = false;
        int size = this.registeredCommands.size();
        for (int i = 0; i < size && !hasRegisteredCommand; hasRegisteredCommand |= this.registeredCommands.get(i).commandName().equals(commandName), ++i) {
        }
        if (hasRegisteredCommand && this.hasCommandConflict(commandName, (AbstractArgument[])args, humanReadableCommandArgSyntax)) {
            return;
        }
        ArrayList<String> argumentsString = new ArrayList<String>();
        for (Argument arg : args) {
            argumentsString.add(((AbstractArgument)arg).getNodeName() + ":" + arg.getClass().getSimpleName());
        }
        RegisteredCommand registeredCommandInformation = new RegisteredCommand(commandName, argumentsString, List.of(args), shortDescription, fullDescription, usageDescription, helpTopic, aliases, permission, namespace);
        this.registeredCommands.add(registeredCommandInformation);
        this.platform.preCommandRegistration(commandName);
        String namespacedCommandName = namespace.isEmpty() ? commandName : namespace + ":" + commandName;
        CommandAPI.logInfo("Registering command /" + namespacedCommandName + " " + humanReadableCommandArgSyntax);
        Command command = this.generateCommand((AbstractArgument[])args, executor, converted);
        ArrayList aliasNodes = new ArrayList();
        if (args.length == 0) {
            resultantNode = this.platform.registerCommandNode((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(commandName).requires(this.generatePermissions(commandName, permission, requirements, namespace))).executes(command), namespace);
            for (String alias : aliases) {
                CommandAPI.logInfo("Registering alias /" + alias + " -> " + resultantNode.getName());
                aliasNodes.add(this.platform.registerCommandNode((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(alias).requires(this.generatePermissions(alias, permission, requirements, namespace))).executes(command), namespace));
            }
        } else {
            ArgumentBuilder commandArguments = this.generateOuterArguments(this.generateInnerArgument(command, (AbstractArgument[])args), (AbstractArgument[])args);
            resultantNode = this.platform.registerCommandNode((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(commandName).requires(this.generatePermissions(commandName, permission, requirements, namespace))).then(commandArguments), namespace);
            for (String alias : aliases) {
                if (CommandAPI.getConfiguration().hasVerboseOutput()) {
                    CommandAPI.logInfo("Registering alias /" + alias + " -> " + resultantNode.getName());
                }
                aliasNodes.add(this.platform.registerCommandNode((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(alias).requires(this.generatePermissions(alias, permission, requirements, namespace))).then(commandArguments), namespace));
            }
        }
        this.writeDispatcherToFile();
        this.platform.postCommandRegistration(registeredCommandInformation, resultantNode, aliasNodes);
    }

    private boolean checkForDuplicateArgumentNodeNames(Argument[] args, String humanReadableCommandArgSyntax, String commandName) {
        HashSet<String> argumentNames = new HashSet<String>();
        for (Argument arg : args) {
            if (arg instanceof Literal) continue;
            if (argumentNames.contains(((AbstractArgument)arg).getNodeName())) {
                CommandAPI.logError("Failed to register command:\n\n  %s %s\n\nBecause the following argument shares the same node name as another argument:\n\n  %s\n".formatted(commandName, humanReadableCommandArgSyntax, ((AbstractArgument)arg).toString()));
                return false;
            }
            argumentNames.add(((AbstractArgument)arg).getNodeName());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeDispatcherToFile() {
        File file = CommandAPI.getConfiguration().getDispatcherFile();
        if (file == null) return;
        try {
            file.getParentFile().mkdirs();
            if (!file.createNewFile()) {
                // empty if block
            }
        }
        catch (IOException e) {
            CommandAPI.logError("Failed to create the required directories for " + file.getName() + ": " + e.getMessage());
            return;
        }
        try {
            this.platform.createDispatcherFile(file, this.platform.getBrigadierDispatcher());
            return;
        }
        catch (IOException e) {
            CommandAPI.logError("Failed to write command registration info to " + file.getName() + ": " + e.getMessage());
        }
    }

    <CommandSource> LiteralCommandNode<CommandSource> namespaceNode(LiteralCommandNode<CommandSource> original, String namespace) {
        LiteralCommandNode clone = new LiteralCommandNode(namespace + ":" + original.getLiteral(), original.getCommand(), original.getRequirement(), original.getRedirect(), original.getRedirectModifier(), original.isFork());
        for (CommandNode child : original.getChildren()) {
            clone.addChild(child);
        }
        return clone;
    }

    LiteralArgumentBuilder<Source> getLiteralArgumentBuilder(String commandName) {
        return LiteralArgumentBuilder.literal((String)commandName);
    }

    LiteralArgumentBuilder<Source> getLiteralArgumentBuilderArgument(String commandName, CommandPermission permission, Predicate<CommandSender> requirements) {
        LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)commandName);
        return (LiteralArgumentBuilder)builder.requires(css -> CommandAPIHandler.permissionCheck(this.platform.getCommandSenderFromCommandSource(css), permission, requirements));
    }

    RequiredArgumentBuilder<Source, ?> getRequiredArgumentBuilderDynamic(Argument[] args, Argument argument) {
        Object suggestions = ((AbstractArgument)argument).getOverriddenSuggestions().isPresent() ? this.toSuggestions((AbstractArgument)argument, (AbstractArgument[])args, true) : (((AbstractArgument)argument).getIncludedSuggestions().isPresent() ? (cmdCtx, builder) -> argument.getRawType().listSuggestions(cmdCtx, builder) : null);
        return this.getRequiredArgumentBuilderWithProvider((AbstractArgument)argument, (AbstractArgument[])args, (SuggestionProvider)suggestions);
    }

    RequiredArgumentBuilder<Source, ?> getRequiredArgumentBuilderWithProvider(Argument argument, Argument[] args, SuggestionProvider<Source> provider) {
        SuggestionProvider newSuggestionsProvider = provider;
        if (((AbstractArgument)argument).getIncludedSuggestions().isPresent() && ((AbstractArgument)argument).getOverriddenSuggestions().isEmpty()) {
            SuggestionProvider addedSuggestions = this.toSuggestions((AbstractArgument)argument, (AbstractArgument[])args, false);
            newSuggestionsProvider = (cmdCtx, builder) -> {
                CompletableFuture addedSuggestionsFuture = addedSuggestions.getSuggestions(cmdCtx, builder);
                CompletableFuture providerSuggestionsFuture = provider.getSuggestions(cmdCtx, builder);
                CompletableFuture result = new CompletableFuture();
                CompletableFuture.allOf(addedSuggestionsFuture, providerSuggestionsFuture).thenRun(() -> {
                    ArrayList<Suggestions> suggestions = new ArrayList<Suggestions>();
                    suggestions.add((Suggestions)addedSuggestionsFuture.join());
                    suggestions.add((Suggestions)providerSuggestionsFuture.join());
                    result.complete(Suggestions.merge((String)cmdCtx.getInput(), suggestions));
                });
                return result;
            };
        }
        RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)((AbstractArgument)argument).getNodeName(), ((AbstractArgument)argument).getRawType());
        return ((RequiredArgumentBuilder)requiredArgumentBuilder.requires(css -> CommandAPIHandler.permissionCheck(this.platform.getCommandSenderFromCommandSource(css), argument.getArgumentPermission(), argument.getRequirements()))).suggests(newSuggestionsProvider);
    }

    CommandArguments generatePreviousArguments(CommandContext<Source> context, Argument[] args, String nodeName) throws CommandSyntaxException {
        ArrayList<Object> previousArguments = new ArrayList<Object>();
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>();
        ArrayList<String> rawArguments = new ArrayList<String>();
        LinkedHashMap<String, String> rawArgumentsMap = new LinkedHashMap<String, String>();
        for (Argument arg : args) {
            Object result;
            if (((AbstractArgument)arg).getNodeName().equals(nodeName) && !(arg instanceof Literal)) break;
            try {
                result = this.parseArgument(context, ((AbstractArgument)arg).getNodeName(), arg, new CommandArguments(previousArguments.toArray(), argsMap, rawArguments.toArray(new String[0]), rawArgumentsMap, "/" + context.getInput()));
            }
            catch (IllegalArgumentException e) {
                result = null;
            }
            if (!((AbstractArgument)arg).isListed()) continue;
            previousArguments.add(result);
            argsMap.put(((AbstractArgument)arg).getNodeName(), result);
            String rawArgumentString = CommandAPIHandler.getRawArgumentInput(context, ((AbstractArgument)arg).getNodeName());
            rawArguments.add(rawArgumentString);
            rawArgumentsMap.put(((AbstractArgument)arg).getNodeName(), rawArgumentString);
        }
        return new CommandArguments(previousArguments.toArray(), argsMap, rawArguments.toArray(new String[0]), rawArgumentsMap, "/" + context.getInput());
    }

    SuggestionProvider<Source> toSuggestions(Argument theArgument, Argument[] args, boolean overrideSuggestions) {
        return (context, builder) -> {
            SuggestionInfo<CommandSender> suggestionInfo = new SuggestionInfo<CommandSender>(this.platform.getCommandSenderFromCommandSource(context.getSource()).getSource(), this.generatePreviousArguments(context, (AbstractArgument[])args, theArgument.getNodeName()), builder.getInput(), builder.getRemaining());
            Optional suggestionsToAddOrOverride = overrideSuggestions ? theArgument.getOverriddenSuggestions() : theArgument.getIncludedSuggestions();
            return suggestionsToAddOrOverride.orElse(ArgumentSuggestions.empty()).suggest(suggestionInfo, builder);
        };
    }

    public static Field getField(Class<?> clazz, String name) {
        return CommandAPIHandler.getField(clazz, name, name);
    }

    public static Field getField(Class<?> clazz, String name, String mojangMappedName) {
        Field result;
        ClassCache key = new ClassCache(clazz, name, mojangMappedName);
        if (FIELDS.containsKey(key)) {
            return FIELDS.get(key);
        }
        try {
            result = clazz.getDeclaredField(SafeVarHandle.USING_MOJANG_MAPPINGS ? mojangMappedName : name);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
        result.setAccessible(true);
        FIELDS.put(key, result);
        return result;
    }

    private record ClassCache(Class<?> clazz, String name, String mojangMappedName) {
    }

    private static final class CartesianProduct {
        private CartesianProduct() {
        }

        public static <T> List<List<T>> getDescartes(List<List<T>> list) {
            ArrayList<List<T>> returnList = new ArrayList<List<T>>();
            CartesianProduct.descartesRecursive(list, 0, returnList, new ArrayList());
            return returnList;
        }

        private static <T> void descartesRecursive(List<List<T>> originalList, int position, List<List<T>> returnList, List<T> cacheList) {
            List<T> originalItemList = originalList.get(position);
            for (int i = 0; i < originalItemList.size(); ++i) {
                ArrayList<T> childCacheList = i == originalItemList.size() - 1 ? cacheList : new ArrayList<T>(cacheList);
                childCacheList.add(originalItemList.get(i));
                if (position == originalList.size() - 1) {
                    returnList.add(childCacheList);
                    continue;
                }
                CartesianProduct.descartesRecursive(originalList, position + 1, returnList, childCacheList);
            }
        }
    }
}

