/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.objz.commandbridge.commandapi.AbstractCommandAPICommand;
import dev.objz.commandbridge.commandapi.CommandAPILogger;
import dev.objz.commandbridge.commandapi.CommandMetaData;
import dev.objz.commandbridge.commandapi.RegisteredCommand;
import dev.objz.commandbridge.commandapi.arguments.AbstractArgument;
import dev.objz.commandbridge.commandapi.arguments.SuggestionProviders;
import dev.objz.commandbridge.commandapi.commandsenders.AbstractCommandSender;
import dev.objz.commandbridge.commandapi.commandsenders.AbstractPlayer;
import dev.objz.commandbridge.commandapi.network.CommandAPIMessenger;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface CommandAPIPlatform<Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender, Source> {
    public void onLoad();

    public void onEnable();

    public void onDisable();

    public AbstractCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<Source> var1, boolean var2);

    public AbstractCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(Source var1);

    public Source getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> var1);

    public AbstractCommandSender<? extends CommandSender> wrapCommandSender(CommandSender var1);

    public void registerPermission(String var1);

    public SuggestionProvider<Source> getSuggestionProvider(SuggestionProviders var1);

    public void preCommandRegistration(String var1);

    public void postCommandRegistration(RegisteredCommand var1, LiteralCommandNode<Source> var2, List<LiteralCommandNode<Source>> var3);

    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> var1, String var2);

    public void unregister(String var1, boolean var2);

    public CommandAPIMessenger<?, ?> setupMessenger();

    public CommandDispatcher<Source> getBrigadierDispatcher();

    public void createDispatcherFile(File var1, CommandDispatcher<Source> var2) throws IOException;

    default public CommandAPILogger getLogger() {
        return new CommandAPILogger(){
            private static final String PREFIX = "[CommandAPI] ";
            private static final String YELLOW = "\u001b[33m";
            private static final String RED = "\u001b[31m";
            private static final String RESET = "\u001b[0m";

            @Override
            public void info(String message) {
                System.out.println(PREFIX + message);
            }

            @Override
            public void warning(String message) {
                System.out.println("\u001b[33m[CommandAPI] " + message + RESET);
            }

            @Override
            public void severe(String message) {
                System.out.println("\u001b[31m[CommandAPI] " + message + RESET);
            }

            @Override
            public void severe(String message, Throwable throwable) {
                System.out.println("\u001b[31m[CommandAPI] " + message + RESET);
                throwable.printStackTrace(System.out);
            }
        };
    }

    public void reloadDataPacks();

    public void updateRequirements(AbstractPlayer<?> var1);

    public AbstractCommandAPICommand<?, Argument, CommandSender> newConcreteCommandAPICommand(CommandMetaData<CommandSender> var1);

    public Argument newConcreteMultiLiteralArgument(String var1, String[] var2);

    public Argument newConcreteLiteralArgument(String var1, String var2);
}

