/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.commandapi;

import dev.objz.commandbridge.commandapi.BukkitTooltip;
import dev.objz.commandbridge.commandapi.CommandAPI;
import dev.objz.commandbridge.commandapi.CommandAPIBukkit;
import dev.objz.commandbridge.commandapi.InternalSpigotConfig;
import dev.objz.commandbridge.commandapi.Platform;
import dev.objz.commandbridge.commandapi.commandsenders.BukkitBlockCommandSender;
import dev.objz.commandbridge.commandapi.commandsenders.BukkitCommandSender;
import dev.objz.commandbridge.commandapi.commandsenders.BukkitConsoleCommandSender;
import dev.objz.commandbridge.commandapi.commandsenders.BukkitEntity;
import dev.objz.commandbridge.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.objz.commandbridge.commandapi.commandsenders.BukkitPlayer;
import dev.objz.commandbridge.commandapi.commandsenders.BukkitProxiedCommandSender;
import dev.objz.commandbridge.commandapi.commandsenders.BukkitRemoteConsoleCommandSender;
import dev.objz.commandbridge.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.objz.commandbridge.commandapi.nms.SpigotNMS;
import dev.objz.commandbridge.commandapi.wrappers.NativeProxyCommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class CommandAPISpigot<Source>
extends CommandAPIBukkit<Source>
implements SpigotNMS<Source> {
    private static CommandAPISpigot<?> spigot;

    protected CommandAPISpigot(InternalSpigotConfig config) {
        this.nms = this.bukkitNMS();
        CommandAPIBukkit.config = config;
        spigot = this;
    }

    public static <Source> CommandAPISpigot<Source> getSpigot() {
        if (spigot != null) {
            return spigot;
        }
        throw new IllegalStateException("Tried to access CommandAPISpigot instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public static InternalSpigotConfig getConfiguration() {
        return (InternalSpigotConfig)CommandAPIBukkit.getConfiguration();
    }

    @Override
    public void onEnable() {
        this.plugin = CommandAPISpigot.getConfiguration().getPlugin();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)CommandAPIBukkit.get().plugin, () -> {
            CommandAPIBukkit.get().getCommandRegistrationStrategy().runTasksAfterServerStart();
            if (!CommandAPISpigot.getConfiguration().skipReloadDatapacks()) {
                CommandAPIBukkit.get().reloadDataPacks();
            }
            CommandAPIBukkit.get().updateHelpForCommands(CommandAPI.getRegisteredCommands());
        }, 0L);
        super.stopCommandRegistrations();
    }

    @Override
    public CommandMap getCommandMap() {
        return this.getNMS().getSimpleCommandMap();
    }

    @Override
    public Platform activePlatform() {
        return Platform.SPIGOT;
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> wrapCommandSender(CommandSender sender) {
        if (sender instanceof BlockCommandSender) {
            BlockCommandSender block = (BlockCommandSender)sender;
            return new BukkitBlockCommandSender(block);
        }
        if (sender instanceof ConsoleCommandSender) {
            ConsoleCommandSender console = (ConsoleCommandSender)sender;
            return new BukkitConsoleCommandSender(console);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return new BukkitPlayer(player);
        }
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            return new BukkitEntity(entity);
        }
        if (sender instanceof NativeProxyCommandSender) {
            NativeProxyCommandSender nativeProxy = (NativeProxyCommandSender)sender;
            return new BukkitNativeProxyCommandSender(nativeProxy);
        }
        if (sender instanceof ProxiedCommandSender) {
            ProxiedCommandSender proxy = (ProxiedCommandSender)sender;
            return new BukkitProxiedCommandSender(proxy);
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            RemoteConsoleCommandSender remote = (RemoteConsoleCommandSender)sender;
            return new BukkitRemoteConsoleCommandSender(remote);
        }
        throw new RuntimeException("Failed to wrap CommandSender " + String.valueOf(sender) + " to a CommandAPI-compatible BukkitCommandSender");
    }

    public static WrapperCommandSyntaxException failWithBaseComponents(BaseComponent ... message) {
        return CommandAPI.failWithMessage(BukkitTooltip.messageFromBaseComponents(message));
    }
}

