/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.objz.commandbridge.commandapi.CommandAPIBukkit;
import dev.objz.commandbridge.commandapi.arguments.CommandAPIArgumentType;
import dev.objz.commandbridge.commandapi.arguments.LocationType;
import dev.objz.commandbridge.commandapi.arguments.SafeOverrideableArgument;
import dev.objz.commandbridge.commandapi.executors.CommandArguments;
import dev.objz.commandbridge.commandapi.wrappers.Location2D;

public class Location2DArgument
extends SafeOverrideableArgument<Location2D, Location2D> {
    private final boolean isPrecise;

    public Location2DArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public Location2DArgument(String nodeName, LocationType type) {
        this(nodeName, type, true);
    }

    public Location2DArgument(String nodeName, LocationType type, boolean centerPosition) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get().getNMS()._ArgumentPosition2D() : CommandAPIBukkit.get().getNMS()._ArgumentVec2(centerPosition), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location2D> getPrimitiveType() {
        return Location2D.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION_2D;
    }

    @Override
    public <CommandSourceStack> Location2D parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getNMS().getLocation2DPrecise(cmdCtx, key) : CommandAPIBukkit.get().getNMS().getLocation2DBlock(cmdCtx, key);
    }
}

