/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.core.json;

import java.time.Instant;
import org.json.JSONObject;

public class MessageBuilder {
    private final JSONObject jsonObject = new JSONObject();
    private final JSONObject bodyObject = new JSONObject();

    public MessageBuilder(String type) {
        this.jsonObject.put("type", type);
        this.jsonObject.put("body", this.bodyObject);
        this.jsonObject.put("timestamp", Instant.now().toString());
    }

    public MessageBuilder addToBody(String key, Object value) {
        this.bodyObject.put(key, value);
        return this;
    }

    public MessageBuilder withStatus(String status) {
        this.jsonObject.put("status", status);
        return this;
    }

    public JSONObject build() {
        return this.jsonObject;
    }
}

