/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.core.websocket;

import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.json.MessageBuilder;
import dev.objz.commandbridge.core.json.MessageParser;
import dev.objz.commandbridge.core.utils.TLSUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class WebSocketServer {
    private final Logger logger;
    private Channel serverChannel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private final Set<Channel> connections = Collections.synchronizedSet(new HashSet());
    private final Set<Channel> pendingAuthConnections = Collections.synchronizedSet(new HashSet());
    private final String secret;
    private final int authTimeoutMillis = 5000;
    private InetSocketAddress serverAddress;
    private final List<ChannelHandler> extraHandlers = new ArrayList<ChannelHandler>();

    public WebSocketServer(Logger logger, String secret) {
        this.logger = logger;
        this.secret = secret;
    }

    public boolean isRunning() {
        if (this.serverChannel == null) {
            return false;
        }
        try {
            if (this.serverAddress != null && this.isPortInUse(this.serverAddress.getPort())) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error checking server status: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
        return false;
    }

    public void addHttpHandler(ChannelHandler handler) {
        this.extraHandlers.add(handler);
    }

    public Set<Channel> getConnections() {
        return this.connections;
    }

    private boolean isPortInUse(int port) {
        boolean bl;
        ServerSocket serverSocket = new ServerSocket(port);
        try {
            serverSocket.setReuseAddress(true);
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        serverSocket.close();
        return bl;
    }

    public void startServer(int port, String address, String SAN) {
        if (this.isRunning()) {
            throw new RuntimeException("WebSocket server is already running on " + address + ":" + port);
        }
        try {
            this.serverAddress = new InetSocketAddress(address, port);
            final SSLContext sslContext = TLSUtils.createServerSSLContext(SAN);
            if (sslContext == null) {
                throw new RuntimeException("Failed to initialize SSL context");
            }
            this.bossGroup = new NioEventLoopGroup(1);
            this.workerGroup = new NioEventLoopGroup();
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    SSLEngine sslEngine = sslContext.createSSLEngine();
                    sslEngine.setUseClientMode(false);
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new SslHandler(sslEngine));
                    pipeline.addLast(new HttpServerCodec());
                    pipeline.addLast(new HttpObjectAggregator(65536));
                    for (ChannelHandler handler : WebSocketServer.this.extraHandlers) {
                        pipeline.addLast(handler);
                    }
                    pipeline.addLast(new WebSocketServerProtocolHandler("/", null, true));
                    pipeline.addLast(new WebSocketFrameHandler());
                }
            });
            ChannelFuture future = bootstrap.bind(this.serverAddress).sync();
            this.serverChannel = future.channel();
            this.logger.info("WebSocket server started on: {}:{}", address, port);
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting WebSocket server", e);
        }
    }

    public void stopServer(int timeout) {
        if (this.serverChannel != null) {
            try {
                this.logger.debug("Closing all client connections...", new Object[0]);
                for (Channel conn : this.connections) {
                    conn.writeAndFlush(new CloseWebSocketFrame(1001, "Server shutdown"));
                    conn.close();
                }
                this.connections.clear();
                this.pendingAuthConnections.clear();
                this.serverChannel.close().sync();
                if (this.bossGroup != null) {
                    this.bossGroup.shutdownGracefully(0L, timeout, TimeUnit.MILLISECONDS).sync();
                }
                if (this.workerGroup != null) {
                    this.workerGroup.shutdownGracefully(0L, timeout, TimeUnit.MILLISECONDS).sync();
                }
                this.serverChannel = null;
                this.bossGroup = null;
                this.workerGroup = null;
                this.logger.info("WebSocket server stopped successfully", new Object[0]);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to stop WebSocket server gracefully", e);
            }
        } else {
            this.logger.warn("WebSocket server is not running.", new Object[0]);
        }
    }

    public void sendMessage(JSONObject message, Channel conn) {
        conn.writeAndFlush(new TextWebSocketFrame(message.toString()));
    }

    private void handleMessage(ChannelHandlerContext ctx, String message) {
        Channel conn = ctx.channel();
        try {
            MessageParser parser = new MessageParser(message);
            if (parser.getType().equals("auth")) {
                this.pendingAuthConnections.remove(conn);
                String receivedSecret = parser.getBodyValueAsString("secret");
                MessageBuilder builder = new MessageBuilder("auth");
                if (receivedSecret.equals(this.secret)) {
                    this.logger.info("Client authenticated successfully: {}", conn.remoteAddress());
                    this.connections.add(conn);
                    builder.withStatus("authenticated");
                    this.sendMessage(builder.build(), conn);
                } else {
                    this.logger.warn("Client failed to authenticate: {}", conn.remoteAddress());
                    builder.withStatus("unauthenticated");
                    this.sendMessage(builder.build(), conn);
                    conn.close();
                }
            } else if (this.connections.contains(conn)) {
                this.onMessage(conn, message);
            }
        }
        catch (JSONException e) {
            this.logger.error("Failed to parse message: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
    }

    protected abstract void onMessage(Channel var1, String var2);

    protected abstract void onConnectionClose(Channel var1, int var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastClientMessage(JSONObject message, Channel client) {
        Set<Channel> set = this.connections;
        synchronized (set) {
            for (Channel conn : this.connections) {
                if (conn == client) continue;
                this.sendMessage(message, conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastServerMessage(JSONObject message) {
        Set<Channel> set = this.connections;
        synchronized (set) {
            for (Channel conn : this.connections) {
                this.sendMessage(message, conn);
            }
        }
        this.logger.debug("Broadcast server message", new Object[0]);
    }

    private class WebSocketFrameHandler
    extends SimpleChannelInboundHandler<WebSocketFrame> {
        private WebSocketFrameHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            final Channel conn = ctx.channel();
            WebSocketServer.this.pendingAuthConnections.add(conn);
            Timer authTimer = new Timer();
            authTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (WebSocketServer.this.pendingAuthConnections.contains(conn)) {
                        MessageBuilder builder = new MessageBuilder("auth");
                        builder.addToBody("message", "Authentication timeout.");
                        builder.withStatus("error");
                        conn.writeAndFlush(new TextWebSocketFrame(builder.build().toString()));
                        conn.close();
                    }
                }
            }, 5000L);
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            Channel conn = ctx.channel();
            WebSocketServer.this.connections.remove(conn);
            WebSocketServer.this.pendingAuthConnections.remove(conn);
            WebSocketServer.this.onConnectionClose(conn, 1000, "Connection closed");
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                WebSocketServer.this.handleMessage(ctx, textFrame.text());
            } else if (frame instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
                ctx.close();
                WebSocketServer.this.onConnectionClose(ctx.channel(), closeFrame.statusCode(), closeFrame.reasonText());
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            WebSocketServer.this.logger.error("An error occurred: {}", WebSocketServer.this.logger.getDebug() != false ? cause : cause.getMessage());
            ctx.close();
        }
    }
}

