/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.paper.command;

import dev.objz.commandbridge.commandapi.CommandAPI;
import dev.objz.commandbridge.commandapi.CommandAPICommand;
import dev.objz.commandbridge.commandapi.arguments.Argument;
import dev.objz.commandbridge.commandapi.arguments.GreedyStringArgument;
import dev.objz.commandbridge.commandapi.executors.ExecutorType;
import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.utils.ScriptManager;
import dev.objz.commandbridge.paper.command.outbound.CommandSender;
import dev.objz.commandbridge.paper.core.Runtime;
import java.util.ArrayList;
import java.util.List;

public class CommandRegistrar {
    private final Logger logger;
    private final List<String> registeredCommands = new ArrayList<String>();
    private final CommandSender bridgeSender;

    public CommandRegistrar(Logger logger) {
        this.logger = logger;
        this.bridgeSender = Runtime.getInstance().getSender();
    }

    public void unregisterAllCommands() {
        for (String command : this.registeredCommands) {
            try {
                CommandAPI.unregister(command);
                this.logger.debug("Unregistered command: {}", command);
            }
            catch (Exception e) {
                this.logger.error("Failed to unregister command '{}' : {}", command, this.logger.getDebug() != false ? e : e.getMessage());
            }
        }
        this.registeredCommands.clear();
        this.logger.info("All registered commands have been unregistered.", new Object[0]);
    }

    public void registerCommand(ScriptManager.ScriptConfig script) {
        String commandName = script.getName();
        try {
            CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(commandName).withOptionalArguments(new Argument[]{new GreedyStringArgument("args")})).withAliases(script.getAliases().toArray(new String[0]))).executes((sender, args) -> {
                String argsString = (String)args.get("args");
                this.logger.debug("Command '{}' called with arguments: {}", commandName, argsString);
                String[] splitArgs = argsString == null || argsString.isBlank() ? new String[]{} : argsString.split(" ");
                return this.bridgeSender.executeScriptCommands(sender, script, splitArgs);
            }, new ExecutorType[0]);
            command.register();
            this.registeredCommands.add(commandName);
            this.logger.debug("Registered command: {}", commandName);
        }
        catch (Exception e) {
            this.logger.error("Failed to register command '{}' : {}", commandName, this.logger.getDebug() != false ? e : e.getMessage());
        }
    }
}

