/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.paper.websocket;

import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.utils.ConfigManager;
import dev.objz.commandbridge.paper.core.Runtime;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Ping {
    private static void startPing(final Logger logger, final Runnable onPong, final String url, final int port, final int maxAttempts) {
        int millis = 4000;
        final Timer timer = new Timer();
        Ping.disableCertificateValidation();
        timer.scheduleAtFixedRate(new TimerTask(){
            int attempts = 0;

            @Override
            public void run() {
                ++this.attempts;
                if (this.attempts > maxAttempts) {
                    logger.warn("Max reconnect attempts reached. Reconnect manual by running '/cbc reconnect'", new Object[0]);
                    timer.cancel();
                    return;
                }
                try {
                    URL targetUrl = new URL("https://" + url + ":" + port + "/ping");
                    HttpsURLConnection conn = (HttpsURLConnection)targetUrl.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(1500);
                    conn.setReadTimeout(1500);
                    logger.debug("Pinging WebsocketServer", new Object[0]);
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 200) {
                        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        String response = in.readLine();
                        in.close();
                        if ("pong".equalsIgnoreCase(response)) {
                            logger.info("Attempting to reconnect to the server!", new Object[0]);
                            onPong.run();
                            timer.cancel();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 4000L);
    }

    public static void reconnect(Logger logger) {
        int attempts;
        ConfigManager config = Runtime.getInstance().getConfig();
        try {
            attempts = Integer.parseInt(config.getKey("config.yml", "timeout")) / 4;
        }
        catch (RuntimeException e) {
            attempts = 30;
        }
        Ping.startPing(logger, () -> {
            Runtime.getInstance().getClient().disconnect();
            String host = config.getKey("config.yml", "remote");
            int port = Integer.parseInt(config.getKey("config.yml", "port"));
            try {
                Runtime.getInstance().getClient().connect(host, port);
                logger.info("Client reconnected successfully to {}:{}", host, port);
            }
            catch (Exception e) {
                logger.error("Client reconnection failed (but ping succeeded):", e);
            }
        }, config.getKey("config.yml", "remote"), Integer.parseInt(config.getKey("config.yml", "port")), attempts);
    }

    private static void disableCertificateValidation() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to disable certificate validation", e);
        }
    }
}

