/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.velocity.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.utils.ScriptManager;
import dev.objz.commandbridge.velocity.command.outbound.CommandSender;
import dev.objz.commandbridge.velocity.core.Runtime;
import dev.objz.commandbridge.velocity.util.ProxyUtils;
import java.util.HashMap;
import java.util.Map;

public class CommandRegistrar {
    private final Logger logger;
    private final ProxyServer proxy;
    private final CommandSender sender;
    private final Map<String, CommandMeta> registeredCommands = new HashMap<String, CommandMeta>();

    public CommandRegistrar(Logger logger) {
        this.logger = logger;
        this.proxy = ProxyUtils.getProxyServer();
        this.sender = Runtime.getInstance().getSender();
    }

    public void unregisterAllCommands() {
        for (String command : this.registeredCommands.keySet()) {
            try {
                CommandMeta commandMeta = this.registeredCommands.get(command);
                this.proxy.getCommandManager().unregister(commandMeta);
                this.logger.debug("Unregistered command: {}", command);
            }
            catch (Exception e) {
                this.logger.error("Failed to unregister command '{}' : {}", command, this.logger.getDebug() != false ? e : e.getMessage());
            }
        }
        this.registeredCommands.clear();
        this.logger.info("All registered commands have been unregistered.", new Object[0]);
    }

    public void registerCommand(ScriptManager.ScriptConfig script) {
        String commandName = script.getName();
        try {
            LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)commandName).executes(context -> {
                this.logger.debug("Executing base command: {}", commandName);
                return this.sender.executeScriptCommands((CommandSource)context.getSource(), script, new String[0]);
            });
            RequiredArgumentBuilder argsArgument = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
                String argsString = (String)context.getArgument("args", String.class);
                this.logger.debug("Command '{}' called with arguments: {}", commandName, argsString);
                String[] args = argsString.split(" ");
                return this.sender.executeScriptCommands((CommandSource)context.getSource(), script, args);
            });
            commandBuilder.then((ArgumentBuilder)argsArgument);
            BrigadierCommand brigadierCommand = new BrigadierCommand(commandBuilder.build());
            CommandMeta commandMeta = this.proxy.getCommandManager().metaBuilder(commandName).aliases(script.getAliases().toArray(new String[0])).build();
            this.proxy.getCommandManager().register(commandMeta, (Command)brigadierCommand);
            this.registeredCommands.put(commandName, commandMeta);
        }
        catch (Exception e) {
            this.logger.error("Failed to register command '{}' : {}", commandName, this.logger.getDebug() != false ? e : e.getMessage());
        }
    }
}

