/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.velocity.websocket;

import com.velocitypowered.api.proxy.Player;
import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.json.MessageBuilder;
import dev.objz.commandbridge.core.json.MessageParser;
import dev.objz.commandbridge.core.websocket.WebSocketServer;
import dev.objz.commandbridge.velocity.core.Runtime;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Server
extends WebSocketServer {
    private final Logger logger;
    private final Map<String, Channel> clientConnections = new HashMap<String, Channel>();

    public Server(Logger logger, String secret) {
        super(logger, secret);
        super.addHttpHandler(Runtime.getInstance().getHttpServer());
        this.logger = logger;
    }

    @Override
    protected void onMessage(Channel webSocket, String message) {
        MessageParser parser = new MessageParser(message);
        this.logger.debug("Received message: {}", message);
        try {
            String type;
            switch (type = parser.getType()) {
                case "command": {
                    this.handleCommandRequest(webSocket, message);
                    break;
                }
                case "system": {
                    this.handleSystemRequest(webSocket, message);
                    break;
                }
                default: {
                    this.logger.warn("Invalid type: {}", type);
                    this.sendError(webSocket, "Invalid type: " + type);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error while processing message: {}", this.logger.getDebug() != false ? e : e.getMessage());
            this.sendError(webSocket, "Internal server error: " + e.getMessage());
        }
    }

    @Override
    protected void onConnectionClose(Channel conn, int code, String reason) {
        String clientAddress = conn.remoteAddress().toString();
        if (this.getConnections().contains(conn)) {
            String disconnectedClientName = this.clientConnections.entrySet().stream().filter(entry -> ((Channel)entry.getValue()).equals(conn)).map(Map.Entry::getKey).findFirst().orElse(null);
            this.logger.info("Client '{}' disconnected", clientAddress);
            if (disconnectedClientName != null) {
                this.clientConnections.remove(disconnectedClientName);
                this.logger.debug("Removed disconnected client: {}", disconnectedClientName);
            } else {
                this.logger.warn("Disconnected WebSocket client '{}' not found in client connections map.", clientAddress);
            }
        }
    }

    private void handleCommandRequest(Channel webSocket, String message) {
        this.logger.debug("Handling command request", new Object[0]);
        Runtime.getInstance().getCommandHandler().dispatchCommand(message);
    }

    private void handleSystemRequest(Channel webSocket, String message) {
        this.logger.debug("Handling system request", new Object[0]);
        MessageParser parser = new MessageParser(message);
        String channel = parser.getBodyValueAsString("channel");
        String name = parser.getBodyValueAsString("name");
        String client = parser.getBodyValueAsString("client");
        String status = parser.getStatus();
        switch (channel) {
            case "name": {
                if (name != null) {
                    this.clientConnections.put(name, webSocket);
                    this.logger.info("Added connected client: {}", name);
                    break;
                }
                this.logger.warn("Client did not provide 'name' in system request", new Object[0]);
                break;
            }
            case "error": {
                this.logger.warn("Message from client '{}' : {}", client, status);
                break;
            }
            case "info": {
                this.logger.info("Message from client '{}' : {}", client, status);
                break;
            }
            case "task": {
                this.systemTask(parser, status, client);
                break;
            }
            default: {
                this.logger.warn("Invalid channel: {}", channel);
            }
        }
    }

    private void systemTask(MessageParser parser, String status, String client) {
        String task;
        switch (task = parser.getBodyValueAsString("task")) {
            case "reload": {
                Runtime.getInstance().getGeneralUtils().addClientToStatus(client, parser.getStatus());
                break;
            }
            case "dump": {
                Runtime.getInstance().getEncoder().addClient(parser.getBodyValueAsString("client"), parser.getBodyValueAsString("compressed"));
                break;
            }
            default: {
                this.logger.warn("Invalid task: {}", task);
            }
        }
    }

    public void sendError(Channel webSocket, String errorMessage) {
        MessageBuilder builder = new MessageBuilder("system");
        builder.addToBody("channel", "error").addToBody("server", Runtime.getInstance().getConfig().getKey("config.yml", "server-id")).withStatus(errorMessage);
        this.sendMessage(builder.build(), webSocket);
    }

    public void sendInfo(Channel webSocket, String infoMessage) {
        MessageBuilder builder = new MessageBuilder("system");
        builder.addToBody("channel", "info").addToBody("server", Runtime.getInstance().getConfig().getKey("config.yml", "server-id")).withStatus(infoMessage);
        this.sendMessage(builder.build(), webSocket);
    }

    public void sendTask(Channel webSocket, String task, String status) {
        MessageBuilder builder = new MessageBuilder("system");
        builder.addToBody("channel", "task").addToBody("task", task).addToBody("server", Runtime.getInstance().getConfig().getKey("config.yml", "server-id")).withStatus(status);
        this.sendMessage(builder.build(), webSocket);
    }

    public void sendCommand(String command, String client, String target, Player executor) {
        Channel conn = this.clientConnections.get(client);
        if (conn == null) {
            this.logger.warn("Client '{}' is not connected, cannot send message.", client);
            return;
        }
        MessageBuilder builder = new MessageBuilder("command");
        builder.addToBody("command", command).addToBody("client", client).addToBody("target", target);
        if (target.equals("player")) {
            builder.addToBody("name", executor.getUsername()).addToBody("uuid", executor.getUniqueId());
        }
        this.logger.info("Sending command '{}' to client: {}", command, client);
        this.logger.debug("Sending payload: {}", builder.build().toString());
        this.sendMessage(builder.build(), conn);
    }

    public boolean isServerConnected(String clientName) {
        boolean exists = this.clientConnections.containsKey(clientName);
        this.logger.debug("Checking if client '{}' is connected: {}", clientName, exists);
        return exists;
    }

    public Set<String> getConnectedClients() {
        return this.clientConnections.keySet();
    }

    public Channel getWebSocket(String client) {
        return this.clientConnections.get(client);
    }
}

