/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;

public class CompoundConverter<A, B, C>
implements Converter<A, C> {
    private final Converter<A, B> first;
    private final Converter<B, C> second;

    public CompoundConverter(Converter<A, B> first, Converter<B, C> second) {
        this.first = Assert.notNull(first, "First converter cannot be null.");
        this.second = Assert.notNull(second, "Second converter cannot be null.");
    }

    @Override
    public C applyTo(A a2) {
        B b2 = this.first.applyTo(a2);
        return this.second.applyTo(b2);
    }

    @Override
    public A applyFrom(C c2) {
        B b2 = this.second.applyFrom(c2);
        return this.first.applyFrom(b2);
    }
}

