/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;

public class DefaultParameter<T>
implements Parameter<T> {
    private final String ID;
    private final String NAME;
    private final boolean SECRET;
    private final Class<T> IDIOMATIC_TYPE;
    private final Class<? extends Collection<T>> COLLECTION_TYPE;
    private final Converter<T, Object> CONVERTER;

    public DefaultParameter(String id, String name, boolean secret, Class<T> idiomaticType, Class<? extends Collection<T>> collectionType, Converter<T, Object> converter) {
        this.ID = Strings.clean(Assert.hasText(id, "ID argument cannot be null or empty."));
        this.NAME = Strings.clean(Assert.hasText(name, "Name argument cannot be null or empty."));
        this.IDIOMATIC_TYPE = Assert.notNull(idiomaticType, "idiomaticType argument cannot be null.");
        this.CONVERTER = Assert.notNull(converter, "Converter argument cannot be null.");
        this.SECRET = secret;
        this.COLLECTION_TYPE = collectionType;
    }

    @Override
    public String getId() {
        return this.ID;
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    @Override
    public boolean supports(Object value) {
        if (value == null) {
            return true;
        }
        if (this.COLLECTION_TYPE != null && this.COLLECTION_TYPE.isInstance(value)) {
            Collection<T> c2 = this.COLLECTION_TYPE.cast(value);
            return c2.isEmpty() || this.IDIOMATIC_TYPE.isInstance(c2.iterator().next());
        }
        return this.IDIOMATIC_TYPE.isInstance(value);
    }

    @Override
    public T cast(Object value) {
        if (value != null) {
            if (this.COLLECTION_TYPE != null) {
                T element;
                if (!this.COLLECTION_TYPE.isInstance(value)) {
                    String msg = "Cannot cast " + value.getClass().getName() + " to " + this.COLLECTION_TYPE.getName() + "<" + this.IDIOMATIC_TYPE.getName() + ">";
                    throw new ClassCastException(msg);
                }
                Collection<T> c2 = this.COLLECTION_TYPE.cast(value);
                if (!c2.isEmpty() && !this.IDIOMATIC_TYPE.isInstance(element = c2.iterator().next())) {
                    String msg = "Cannot cast " + value.getClass().getName() + " to " + this.COLLECTION_TYPE.getName() + "<" + this.IDIOMATIC_TYPE.getName() + ">: At least one " + "element is not an instance of " + this.IDIOMATIC_TYPE.getName();
                    throw new ClassCastException(msg);
                }
            } else if (!this.IDIOMATIC_TYPE.isInstance(value)) {
                String msg = "Cannot cast " + value.getClass().getName() + " to " + this.IDIOMATIC_TYPE.getName();
                throw new ClassCastException(msg);
            }
        }
        return (T)value;
    }

    @Override
    public boolean isSecret() {
        return this.SECRET;
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            return this.ID.equals(((Parameter)obj).getId());
        }
        return false;
    }

    public String toString() {
        return "'" + this.ID + "' (" + this.NAME + ")";
    }

    @Override
    public Object applyTo(T t) {
        return this.CONVERTER.applyTo(t);
    }

    @Override
    public T applyFrom(Object o) {
        return this.CONVERTER.applyFrom(o);
    }
}

