/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.objz.commandbridge.commandapi.arguments.CommandAPIArgumentType;
import dev.objz.commandbridge.commandapi.arguments.SafeOverrideableArgument;
import dev.objz.commandbridge.commandapi.exceptions.InvalidRangeException;
import dev.objz.commandbridge.commandapi.executors.CommandArguments;

public class DoubleArgument
extends SafeOverrideableArgument<Double, Double> {
    public DoubleArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg(), String::valueOf);
    }

    public DoubleArgument(String nodeName, double min) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg((double)min), String::valueOf);
    }

    public DoubleArgument(String nodeName, double min, double max) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg((double)min, (double)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Double> getPrimitiveType() {
        return Double.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_DOUBLE;
    }

    @Override
    public <Source> Double parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Double)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

