/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.core.websocket;

import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.json.MessageBuilder;
import dev.objz.commandbridge.core.json.MessageParser;
import dev.objz.commandbridge.core.utils.TLSUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslHandler;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class WebSocketClient {
    private Channel channel;
    private EventLoopGroup group;
    private final Logger logger;
    private final String secret;
    private URI uri;
    private WebSocketClientHandshaker handshaker;

    public WebSocketClient(Logger logger, String secret) {
        this.logger = logger;
        this.secret = secret;
    }

    public void connect(String address, int port) {
        try {
            this.uri = new URI("wss://" + address + ":" + port);
            this.group = new NioEventLoopGroup();
            final SSLContext sslContext = TLSUtils.createClientSSLContext();
            if (sslContext == null) {
                throw new RuntimeException("Failed to initialize SSL context");
            }
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    SSLEngine sslEngine = sslContext.createSSLEngine();
                    sslEngine.setUseClientMode(true);
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new SslHandler(sslEngine));
                    pipeline.addLast(new HttpClientCodec());
                    pipeline.addLast(new HttpObjectAggregator(8192));
                    pipeline.addLast(new WebSocketClientHandler());
                }
            });
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(this.uri, WebSocketVersion.V13, null, false, new DefaultHttpHeaders());
            this.logger.info("Attempting to connect to server at: {}:{}", address, port);
            ChannelFuture future = bootstrap.connect(this.uri.getHost(), port).sync();
            this.channel = future.channel();
        }
        catch (Exception e) {
            throw new RuntimeException("Connection failed", e);
        }
    }

    public void disconnect() {
        if (this.channel != null && this.channel.isActive()) {
            try {
                this.channel.writeAndFlush(new CloseWebSocketFrame());
                this.channel.closeFuture().await(5L, TimeUnit.SECONDS);
                this.logger.info("Disconnected successfully", new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to disconnect WebSocket client", e);
            }
            finally {
                this.group.shutdownGracefully();
            }
        } else {
            this.logger.warn("Client is not connected, so no need to disconnect", new Object[0]);
        }
    }

    public void sendMessage(JSONObject message) {
        if (this.channel != null && this.channel.isActive()) {
            this.channel.writeAndFlush(new TextWebSocketFrame(message.toString()));
        } else {
            this.logger.warn("Client is not connected, so cannot send message", new Object[0]);
        }
    }

    private void handleMessage(String message) {
        try {
            MessageParser parser = new MessageParser(message);
            if (parser.getType().equals("auth")) {
                String status;
                String string = status = parser.getStatus();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"authenticated", "unauthenticated", "error"}, (Object)string, n)) {
                    case 0: {
                        this.logger.info("Authentication succeeded", new Object[0]);
                        this.afterAuth();
                        break;
                    }
                    case 1: {
                        this.logger.error("Authentication failed", new Object[0]);
                        this.channel.close();
                        break;
                    }
                    case 2: {
                        this.logger.warn("Received error from server: {}", parser.getBodyValueAsString("message"));
                        break;
                    }
                    default: {
                        this.logger.error("Received not a valid status", new Object[0]);
                        break;
                    }
                }
            } else {
                this.onMessage(message);
            }
        }
        catch (JSONException e) {
            this.logger.error("Failed to parse message: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
    }

    protected abstract void onMessage(String var1);

    protected abstract void afterAuth();

    private class WebSocketClientHandler
    extends SimpleChannelInboundHandler<Object> {
        private WebSocketClientHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            WebSocketClient.this.handshaker.handshake(ctx.channel());
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            WebSocketClient.this.logger.info("WebSocket Client disconnected!", new Object[0]);
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel ch = ctx.channel();
            if (!WebSocketClient.this.handshaker.isHandshakeComplete()) {
                WebSocketClient.this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                WebSocketClient.this.logger.info("Connected to server: {}", WebSocketClient.this.uri);
                MessageBuilder builder = new MessageBuilder("auth");
                builder.addToBody("secret", WebSocketClient.this.secret);
                JSONObject authMessage = builder.build();
                ch.writeAndFlush(new TextWebSocketFrame(authMessage.toString()));
                return;
            }
            if (msg instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)msg;
                WebSocketClient.this.handleMessage(textFrame.text());
            } else if (msg instanceof CloseWebSocketFrame) {
                ch.close();
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            WebSocketClient.this.logger.error("An error occurred: {}", WebSocketClient.this.logger.getDebug() != false ? cause : cause.getMessage());
            ctx.close();
        }
    }
}

