/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.paper;

import dev.objz.commandbridge.commandapi.CommandAPI;
import dev.objz.commandbridge.commandapi.CommandAPIPaperConfig;
import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.paper.core.Runtime;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.io.InputStream;
import java.util.Properties;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main instance;
    private final Logger logger;

    public Main() {
        instance = this;
        this.logger = Runtime.getInstance().getLogger();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream input = Main.class.getClassLoader().getResourceAsStream("plugin.properties");){
            if (input == null) {
                String string2 = "Unknown";
                return string2;
            }
            Properties properties = new Properties();
            properties.load(input);
            String string = properties.getProperty("plugin.version", "Unknown");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unknown";
        }
    }

    public static Main getInstance() {
        return instance;
    }

    public void onLoad() {
        CommandAPI.onLoad(((CommandAPIPaperConfig)new CommandAPIPaperConfig((LifecycleEventOwner)this).verboseOutput(false)).silentLogs(true));
    }

    public void onEnable() {
        CommandAPI.onEnable();
        this.logger.info("Initializing CommandBridge...", new Object[0]);
        Runtime.getInstance().getStartup().start();
    }

    public void onDisable() {
        CommandAPI.onDisable();
        this.logger.info("Stopping CommandBridge...", new Object[0]);
        Runtime.getInstance().getStartup().stop();
    }

    public static ServerInfo detectServer() {
        Package pkg = Bukkit.getServer().getClass().getPackage();
        String title = pkg.getImplementationTitle();
        String version = pkg.getImplementationVersion();
        if (title != null && !title.isBlank() && version != null && !version.isBlank()) {
            return new ServerInfo(title, version);
        }
        String fallbackName = Bukkit.getServer().getName();
        String fallbackVersion = Bukkit.getServer().getVersion();
        return new ServerInfo(fallbackName, fallbackVersion);
    }

    public record ServerInfo(String name, String version) {
    }
}

