/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.paper.command.inbound;

import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.json.MessageParser;
import dev.objz.commandbridge.paper.Main;
import dev.objz.commandbridge.paper.core.Runtime;
import dev.objz.commandbridge.paper.utils.CommandUtils;
import dev.objz.commandbridge.paper.utils.SchedulerAdapter;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandHandler {
    private final Main plugin = Main.getInstance();
    private final Logger logger = Runtime.getInstance().getLogger();

    public void dispatchCommand(String message) {
        MessageParser parser = new MessageParser(message);
        String serverId = Runtime.getInstance().getConfig().getKey("config.yml", "client-id");
        if (!parser.getBodyValueAsString("client").equals(serverId)) {
            this.logger.debug("Message not intended for this client: {}", serverId);
            return;
        }
        String command = parser.getBodyValueAsString("command");
        String target = parser.getBodyValueAsString("target");
        this.logger.info("Dispatching command '{}' for executor: {}", command, target);
        switch (target) {
            case "console": {
                this.executeConsoleCommand(command);
                break;
            }
            case "player": {
                this.executePlayerCommand(parser, command);
                break;
            }
            default: {
                this.logger.warn("Invalid target: {}", target);
            }
        }
    }

    private void executeConsoleCommand(String command) {
        this.logger.debug("Executing command '{}' as console", command);
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        new SchedulerAdapter(this.plugin).run(() -> this.lambda$executeConsoleCommand$0(command, (CommandSender)console));
    }

    private void executePlayerCommand(MessageParser parser, String command) {
        this.logger.debug("Executing command '{}' as player", command);
        String uuidStr = parser.getBodyValueAsString("uuid");
        String name = parser.getBodyValueAsString("name");
        UUID uuid = UUID.fromString(uuidStr);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || !player.isOnline()) {
            this.logger.warn("Player '{}' not found or offline", name);
            Runtime.getInstance().getClient().sendError("Player '" + name + "' not found or offline");
            return;
        }
        if (SchedulerAdapter.isFolia()) {
            player.getScheduler().execute((Plugin)this.plugin, () -> this.executeFoliaCommand(player, command), null, 0L);
        } else {
            new SchedulerAdapter(this.plugin).run(() -> this.executeFoliaCommand(player, command));
        }
    }

    private void executeFoliaCommand(Player player, String command) {
        if (CommandUtils.isCommandValid(command)) {
            this.logger.warn("Invalid command: {}", command);
            Runtime.getInstance().getClient().sendError("Invalid command: " + command);
            return;
        }
        boolean status = Bukkit.dispatchCommand((CommandSender)player, (String)command);
        this.logResult("player", command, status);
    }

    private void logResult(String target, String command, boolean status) {
        if (status) {
            this.logger.info("Successfully executed command '{}' as {}", command, target);
        } else {
            this.logger.warn("Failed to execute command '{}' as {}", command, target);
            Runtime.getInstance().getClient().sendError("Failed to execute command '" + command + "' as " + target);
        }
    }

    private /* synthetic */ void lambda$executeConsoleCommand$0(String command, CommandSender console) {
        if (CommandUtils.isCommandValid(command)) {
            this.logger.warn("Invalid command: {}", command);
            Runtime.getInstance().getClient().sendError("Invalid command: " + command);
            return;
        }
        boolean status = Bukkit.dispatchCommand((CommandSender)console, (String)command);
        this.logResult("console", command, status);
    }
}

