/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.paper.command.outbound;

import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.utils.ScriptManager;
import dev.objz.commandbridge.core.utils.StringParser;
import dev.objz.commandbridge.paper.Main;
import dev.objz.commandbridge.paper.core.Runtime;
import dev.objz.commandbridge.paper.utils.SchedulerAdapter;
import java.util.HashSet;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class CommandSender {
    private final Logger logger;
    private final Main plugin;

    public CommandSender(Logger logger, Main plugin) {
        this.logger = logger;
        this.plugin = plugin;
    }

    public int executeScriptCommands(org.bukkit.command.CommandSender sender, ScriptManager.ScriptConfig script, String[] args) {
        if (this.isPermissionDenied(sender, script)) {
            return 0;
        }
        block8: for (ScriptManager.Command cmd : script.getCommands()) {
            this.logger.debug("Processing command: {}", cmd.getCommand());
            switch (cmd.getTargetExecutor().toLowerCase()) {
                case "player": {
                    this.handlePlayerExecutor(cmd, sender, args);
                    continue block8;
                }
                case "console": {
                    this.handleConsoleExecutor(cmd, sender, args);
                    continue block8;
                }
            }
            this.logger.warn("Unknown target executor for command: {}", cmd.getCommand());
        }
        return 1;
    }

    private boolean isPermissionDenied(org.bukkit.command.CommandSender sender, ScriptManager.ScriptConfig script) {
        if (!script.shouldIgnorePermissionCheck() && !sender.hasPermission("commandbridge.command." + script.getName())) {
            this.logger.warn("Sender '{}' has no permission to use this command", sender);
            if (!script.shouldHidePermissionWarning()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            }
            return true;
        }
        return false;
    }

    private void handlePlayerExecutor(ScriptManager.Command cmd, org.bukkit.command.CommandSender sender, String[] args) {
        if (cmd.isCheckIfExecutorIsPlayer() && !(sender instanceof Player)) {
            this.logger.warn("This command requires a player as executor, but sender is not a player.", new Object[0]);
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command requires a player as executor, but source is not a player object");
            return;
        }
        Player player = (Player)sender;
        String parsedCommand = this.parseCommand(cmd, args, player);
        if (parsedCommand == null) {
            return;
        }
        if (cmd.getDelay() > 0) {
            this.scheduleCommand(cmd, parsedCommand, player);
        } else {
            this.sendCommand(cmd, parsedCommand, player);
        }
    }

    private void handleConsoleExecutor(ScriptManager.Command cmd, org.bukkit.command.CommandSender sender, String[] args) {
        Player playerCtx;
        if (cmd.isCheckIfExecutorIsPlayer()) {
            if (!(sender instanceof Player)) {
                this.logger.warn("Console target requires a player executor, but sender is not a player.", new Object[0]);
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command requires a player as executor, but source is not a player object");
                return;
            }
            playerCtx = (Player)sender;
        } else {
            playerCtx = null;
        }
        String parsedCommand = this.parseCommand(cmd, args, playerCtx);
        if (parsedCommand == null) {
            return;
        }
        if (cmd.getDelay() > 0) {
            this.scheduleCommand(cmd, parsedCommand, playerCtx);
        } else {
            this.sendCommand(cmd, parsedCommand, playerCtx);
        }
    }

    private String parseCommand(ScriptManager.Command cmd, String[] args, Player player) {
        StringParser parser = StringParser.create();
        if (player != null) {
            this.addPlayerPlaceholders(parser, player);
        }
        try {
            StringParser.Result result = parser.validate(cmd.getCommand(), args);
            if (!result.isValid()) {
                Set<String> unresolved = result.getUnresolved();
                if (player == null && cmd.getTargetExecutor().equalsIgnoreCase("console")) {
                    HashSet<String> playerPlaceholders = new HashSet<String>();
                    for (String placeholder : unresolved) {
                        if (!this.isPlayerPlaceholder(placeholder)) continue;
                        playerPlaceholders.add(placeholder);
                    }
                    if (!playerPlaceholders.isEmpty()) {
                        this.logger.error("Console command '{}' contains player placeholders: {}", cmd.getCommand(), playerPlaceholders);
                        Runtime.getInstance().getClient().sendError("Console command contains unresolvable player placeholders: " + String.valueOf(playerPlaceholders));
                        return null;
                    }
                }
                if (!unresolved.isEmpty()) {
                    this.logger.warn("Command '{}' contains unresolved placeholders: {}", cmd.getCommand(), unresolved);
                }
            }
            String parsedCommand = result.getParsed();
            if (Runtime.getInstance().getStartup().isPlaceholderAPI() && player != null) {
                parsedCommand = PlaceholderAPI.setPlaceholders((Player)player, (String)parsedCommand);
            }
            return parsedCommand;
        }
        catch (Exception e) {
            this.logger.error("Error occurred while parsing command: {}", this.logger.getDebug() != false ? e : e.getMessage());
            if (player != null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error occurred while parsing command");
            }
            Runtime.getInstance().getClient().sendError("Error occurred while parsing commands");
            return null;
        }
    }

    private boolean isPlayerPlaceholder(String placeholder) {
        return placeholder.equals("%cb_player%") || placeholder.equals("%cb_uuid%") || placeholder.equals("%cb_world%");
    }

    private void addPlayerPlaceholders(StringParser parser, Player player) {
        this.logger.debug("Adding placeholders for player: {}", player.getName());
        parser.add("%cb_player%", player.getName());
        parser.add("%cb_uuid%", player.getUniqueId().toString());
        parser.add("%cb_world%", player.getWorld().getName());
    }

    private void scheduleCommand(ScriptManager.Command cmd, String command, Player player) {
        this.logger.debug("Scheduling command '{}' with delay: {} seconds", cmd.getCommand(), cmd.getDelay());
        if (player != null) {
            player.sendMessage("Scheduling command with '" + cmd.getDelay() + "' seconds");
        }
        new SchedulerAdapter(this.plugin).runLater(() -> this.sendCommand(cmd, command, player), (long)cmd.getDelay() * 20L);
    }

    private void sendCommand(ScriptManager.Command cmd, String command, Player player) {
        this.logger.info("Sending command to server as {}", player == null ? "console" : "player-context for console");
        Runtime.getInstance().getClient().sendCommand(command, "", cmd.getTargetExecutor(), player);
    }
}

