/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.paper.websocket;

import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.json.MessageBuilder;
import dev.objz.commandbridge.core.json.MessageParser;
import dev.objz.commandbridge.core.websocket.WebSocketClient;
import dev.objz.commandbridge.paper.Main;
import dev.objz.commandbridge.paper.core.Runtime;
import dev.objz.commandbridge.paper.utils.SchedulerAdapter;
import dev.objz.commandbridge.paper.websocket.Ping;
import org.bukkit.entity.Player;

public class Client
extends WebSocketClient {
    private final Logger logger;

    public Client(Logger logger, String secret) {
        super(logger, secret);
        this.logger = logger;
    }

    @Override
    protected void onMessage(String message) {
        MessageParser parser = new MessageParser(message);
        this.logger.debug("Received payload: {}", message);
        try {
            String type;
            switch (type = parser.getType()) {
                case "command": {
                    this.handleCommandRequest(message);
                    break;
                }
                case "system": {
                    this.handleSystemRequest(message);
                    break;
                }
                default: {
                    this.logger.warn("Invalid type: {}", type);
                    this.sendError("Invalid type: " + type);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error while processing message: {}", this.logger.getDebug() != false ? e : e.getMessage());
            this.sendError("Internal client error: " + e.getMessage());
        }
    }

    @Override
    protected void afterAuth() {
        this.logger.debug("Sending server information's...", new Object[0]);
        MessageBuilder builder = new MessageBuilder("system");
        builder.addToBody("channel", "name");
        builder.addToBody("name", Runtime.getInstance().getConfig().getKey("config.yml", "client-id"));
        this.logger.debug("Sending payload: {}", builder.build().toString());
        this.sendMessage(builder.build());
    }

    private void handleCommandRequest(String message) {
        this.logger.debug("Handling command response", new Object[0]);
        Runtime.getInstance().getHandler().dispatchCommand(message);
    }

    private void handleSystemRequest(String message) {
        this.logger.debug("Handling system request", new Object[0]);
        MessageParser parser = new MessageParser(message);
        String channel = parser.getBodyValueAsString("channel");
        String status = parser.getStatus();
        switch (channel) {
            case "error": {
                this.logger.warn("Message from server '{}' : {}", parser.getBodyValueAsString("server"), status);
                break;
            }
            case "info": {
                this.logger.info("Message from server '{}' : {}", parser.getBodyValueAsString("server"), status);
                break;
            }
            case "task": {
                this.systemTask(parser, status);
                break;
            }
            default: {
                this.logger.warn("Invalid channel: {}", channel);
            }
        }
    }

    private void systemTask(MessageParser parser, String status) {
        String task;
        switch (task = parser.getBodyValueAsString("task")) {
            case "reload": {
                Runtime.getInstance().getScriptUtils().unloadCommands(() -> new SchedulerAdapter(Main.getInstance()).runLater(Runtime.getInstance().getGeneralUtils()::reloadAll, 10L));
                break;
            }
            case "reconnect": {
                Ping.reconnect(this.logger);
                break;
            }
            case "dump": {
                String compressed;
                String encoded = Runtime.getInstance().getEncoder().encode();
                try {
                    compressed = Runtime.getInstance().getEncoder().compress(encoded);
                }
                catch (Exception e) {
                    this.logger.error("Failed to compress the dump data: {}", this.logger.getDebug() != false ? e : e.getMessage());
                    this.sendError("Error while processing dump data: " + e.getMessage());
                    return;
                }
                MessageBuilder builder = new MessageBuilder("system");
                builder.addToBody("channel", "task").addToBody("task", "dump").addToBody("client", Runtime.getInstance().getConfig().getKey("config.yml", "client-id")).addToBody("compressed", compressed).withStatus("success");
                this.sendMessage(builder.build());
                break;
            }
            default: {
                this.logger.warn("Invalid task: {}", task);
            }
        }
    }

    public void sendError(String errorMessage) {
        MessageBuilder builder = new MessageBuilder("system");
        builder.addToBody("channel", "error").withStatus(errorMessage).addToBody("client", Runtime.getInstance().getConfig().getKey("config.yml", "client-id"));
        this.sendMessage(builder.build());
    }

    public void sendInfo(String infoMessage) {
        MessageBuilder builder = new MessageBuilder("system");
        builder.addToBody("channel", "info").withStatus(infoMessage).addToBody("client", Runtime.getInstance().getConfig().getKey("config.yml", "client-id"));
        this.sendMessage(builder.build());
    }

    public void sendTask(String task, String status) {
        MessageBuilder builder = new MessageBuilder("system");
        builder.addToBody("channel", "task").addToBody("task", task).addToBody("client", Runtime.getInstance().getConfig().getKey("config.yml", "client-id")).withStatus(status);
        this.sendMessage(builder.build());
    }

    public void sendCommand(String command, String client, String target, Player executor) {
        MessageBuilder builder = new MessageBuilder("command");
        builder.addToBody("command", command).addToBody("client", client).addToBody("target", target);
        if (target.equals("player")) {
            builder.addToBody("name", executor.getName()).addToBody("uuid", executor.getUniqueId());
        }
        this.logger.info("Sending command '{}' to server", command);
        this.logger.debug("Sending payload: {}", builder.build().toString());
        this.sendMessage(builder.build());
    }
}

