/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.velocity.command.inbound;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.json.MessageParser;
import dev.objz.commandbridge.velocity.core.Runtime;
import dev.objz.commandbridge.velocity.util.ProxyUtils;
import java.util.Optional;
import java.util.UUID;

public class CommandHandler {
    private final ProxyServer proxy = ProxyUtils.getProxyServer();
    private final Logger logger = Runtime.getInstance().getLogger();

    public void dispatchCommand(String message) {
        MessageParser parser = new MessageParser(message);
        String command = parser.getBodyValueAsString("command");
        String target = parser.getBodyValueAsString("target");
        this.logger.info("Dispatching command: '{}' for target: {}", command, target);
        switch (target.toLowerCase()) {
            case "console": {
                this.executeConsoleCommand(command);
                break;
            }
            case "player": {
                this.executePlayerCommand(parser, command);
                break;
            }
            default: {
                this.logger.warn("Invalid target: {}", target);
            }
        }
    }

    private void executeConsoleCommand(String command) {
        this.logger.debug("Executing command '{}' as console", command);
        this.proxy.getCommandManager().executeAsync((CommandSource)this.proxy.getConsoleCommandSource(), command).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.logger.error("Error executing console command: {}", throwable);
            }
        });
    }

    private void executePlayerCommand(MessageParser parser, String command) {
        this.logger.debug("Executing command '{}' as player", command);
        String uuidStr = parser.getBodyValueAsString("uuid");
        String name = parser.getBodyValueAsString("name");
        try {
            UUID playerUuid = UUID.fromString(uuidStr);
            Optional playerOptional = this.proxy.getPlayer(playerUuid);
            if (playerOptional.isPresent()) {
                Player player = (Player)playerOptional.get();
                this.proxy.getCommandManager().executeAsync((CommandSource)player, command).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        this.logger.error("Error executing console command: {}", throwable);
                    }
                });
            } else {
                this.logger.warn("Player '{}' not found or offline", name);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while processing player: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
    }
}

