/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.velocity.command.outbound;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.utils.ScriptManager;
import dev.objz.commandbridge.core.utils.StringParser;
import dev.objz.commandbridge.velocity.Main;
import dev.objz.commandbridge.velocity.core.Runtime;
import dev.objz.commandbridge.velocity.util.ProxyUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.william278.papiproxybridge.api.PlaceholderAPI;

public class CommandSender {
    private final Logger logger;
    private final ProxyServer proxy;
    private final Main plugin;
    private final ConcurrentMap<String, Long> cooldowns = new ConcurrentHashMap<String, Long>();

    public CommandSender(Logger logger, Main plugin) {
        this.logger = logger;
        this.proxy = ProxyUtils.getProxyServer();
        this.plugin = plugin;
    }

    public int executeScriptCommands(CommandSource source, ScriptManager.ScriptConfig script, String[] args) {
        this.logger.debug("Executing script commands for script: {}", script.getName());
        if (this.isPermissionDenied(source, script)) {
            return 0;
        }
        block8: for (ScriptManager.Command cmd : script.getCommands()) {
            this.logger.debug("Processing command: {}", cmd.getCommand());
            switch (cmd.getTargetExecutor().toLowerCase()) {
                case "player": {
                    this.handlePlayerExecutor(cmd, source, args);
                    continue block8;
                }
                case "console": {
                    this.handleConsoleExecutor(cmd, source, args);
                    continue block8;
                }
            }
            this.logger.warn("Unknown target executor for command: {}", cmd.getCommand());
        }
        this.logger.info("Script commands executed successfully for command: {}", script.getName());
        return 1;
    }

    private boolean isPermissionDenied(CommandSource source, ScriptManager.ScriptConfig script) {
        if (!script.shouldIgnorePermissionCheck() && !source.hasPermission("commandbridge.command." + script.getName())) {
            this.logger.warn("Sender '{}' has no permission to use this command", source);
            if (!script.shouldHidePermissionWarning()) {
                source.sendMessage((Component)Component.text((String)"You do not have permission to use this command", (TextColor)NamedTextColor.RED));
            }
            return true;
        }
        return false;
    }

    private void handlePlayerExecutor(ScriptManager.Command cmd, CommandSource source, String[] args) {
        if (cmd.isCheckIfExecutorIsPlayer() && !(source instanceof Player)) {
            this.logger.warn("This command requires a player as executor, but source is not a player", new Object[0]);
            source.sendMessage((Component)Component.text((String)"This command requires a player as executor, but source is not a player object", (TextColor)NamedTextColor.RED));
            return;
        }
        Player player = (Player)source;
        if (cmd.isCheckIfExecutorIsOnServer() && !this.isPlayerOnTargetServer(player, cmd)) {
            this.logger.warn("Player '{}' is not on the required server for this command.", player.getUsername());
            source.sendMessage((Component)Component.text((String)("Player " + player.getUsername() + " is not on the required server"), (TextColor)NamedTextColor.YELLOW));
            return;
        }
        this.parseCommand(cmd, args, player).thenAccept(parsedCommand -> {
            if (parsedCommand == null) {
                return;
            }
            if (cmd.getDelay() > 0) {
                this.scheduleCommand(cmd, (String)parsedCommand, args, player, 0);
            } else {
                this.sendCommand(cmd, (String)parsedCommand, args, player, 0);
            }
        });
    }

    private void handleConsoleExecutor(ScriptManager.Command cmd, CommandSource source, String[] args) {
        Player playerCtx;
        if (cmd.isCheckIfExecutorIsPlayer()) {
            if (!(source instanceof Player)) {
                this.logger.warn("Console target requires a player executor, but source is not a player", new Object[0]);
                source.sendMessage((Component)Component.text((String)"This command requires a player as executor, but source is not a player object", (TextColor)NamedTextColor.RED));
                return;
            }
            playerCtx = (Player)source;
            if (cmd.isCheckIfExecutorIsOnServer() && !this.isPlayerOnTargetServer(playerCtx, cmd)) {
                this.logger.warn("Player '{}' is not on the required server for this command.", playerCtx.getUsername());
                source.sendMessage((Component)Component.text((String)("Player " + playerCtx.getUsername() + " is not on the required server"), (TextColor)NamedTextColor.YELLOW));
                return;
            }
        } else {
            playerCtx = null;
        }
        this.parseCommand(cmd, args, playerCtx).thenAccept(parsedCommand -> {
            if (parsedCommand == null) {
                return;
            }
            if (cmd.getDelay() > 0) {
                this.scheduleCommand(cmd, (String)parsedCommand, args, playerCtx, 0);
            } else {
                this.sendCommand(cmd, (String)parsedCommand, args, playerCtx, 0);
            }
        });
    }

    private boolean isPlayerOnTargetServer(Player player, ScriptManager.Command cmd) {
        return player.getCurrentServer().map(serverConn -> cmd.getTargetClientIds().contains(serverConn.getServerInfo().getName())).orElse(false);
    }

    private CompletableFuture<String> parseCommand(ScriptManager.Command cmd, String[] args, Player player) {
        StringParser parser = StringParser.create();
        if (player != null) {
            this.addPlayerPlaceholders(parser, player);
        }
        try {
            StringParser.Result result = parser.validate(cmd.getCommand(), args);
            if (!result.isValid()) {
                Set<String> unresolved = result.getUnresolved();
                if (player == null && cmd.getTargetExecutor().equalsIgnoreCase("console")) {
                    HashSet<String> playerPlaceholders = new HashSet<String>();
                    for (String placeholder : unresolved) {
                        if (!this.isPlayerPlaceholder(placeholder)) continue;
                        playerPlaceholders.add(placeholder);
                    }
                    if (!playerPlaceholders.isEmpty()) {
                        this.logger.error("Console command '{}' contains player placeholders: {}", cmd.getCommand(), playerPlaceholders);
                        for (String conn : cmd.getTargetClientIds()) {
                            Runtime.getInstance().getServer().sendError(Runtime.getInstance().getServer().getWebSocket(conn), "Console command contains unresolvable player placeholders: " + String.valueOf(playerPlaceholders));
                        }
                        return CompletableFuture.completedFuture(null);
                    }
                }
                if (!unresolved.isEmpty()) {
                    this.logger.warn("Command '{}' contains unresolved placeholders: {}", cmd.getCommand(), unresolved);
                }
            }
            String parsedCommand = result.getParsed();
            if (Runtime.getInstance().getStartup().isPlaceholderAPI() && player != null) {
                return PlaceholderAPI.createInstance().formatPlaceholders(parsedCommand, player.getUniqueId()).exceptionally(e -> {
                    this.logger.error("PlaceholderAPI error: {}", this.logger.getDebug() != false ? e : e.getMessage());
                    return parsedCommand;
                });
            }
            return CompletableFuture.completedFuture(parsedCommand);
        }
        catch (Exception e2) {
            this.logger.error("Error occurred while parsing command: {}", this.logger.getDebug() != false ? e2 : e2.getMessage());
            if (player != null) {
                player.sendMessage(Component.text((String)"Error occurred while parsing command").color((TextColor)NamedTextColor.RED));
            }
            for (String conn : cmd.getTargetClientIds()) {
                Runtime.getInstance().getServer().sendError(Runtime.getInstance().getServer().getWebSocket(conn), "Error occurred while parsing commands");
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private boolean isPlayerPlaceholder(String placeholder) {
        return placeholder.equals("%cb_player%") || placeholder.equals("%cb_uuid%") || placeholder.equals("%cb_server%");
    }

    private void addPlayerPlaceholders(StringParser parser, Player player) {
        this.logger.debug("Adding placeholders for player: {}", player.getUsername());
        parser.add("%cb_player%", player.getUsername());
        parser.add("%cb_uuid%", player.getUniqueId().toString());
        parser.add("%cb_server%", player.getCurrentServer().map(srv -> srv.getServerInfo().getName()).orElse("defaultServerName"));
    }

    private void scheduleCommand(ScriptManager.Command cmd, String command, String[] args, Player player, int retryCount) {
        this.logger.debug("Scheduling command '{}' with delay: {} seconds", cmd.getCommand(), cmd.getDelay());
        this.proxy.getScheduler().buildTask((Object)this.plugin, () -> this.sendCommand(cmd, command, args, player, retryCount)).delay((long)cmd.getDelay(), TimeUnit.SECONDS).schedule();
    }

    private void sendCommand(ScriptManager.Command cmd, String command, String[] args, Player player, int retryCount) {
        boolean shouldGateOnPlayerOnline;
        this.logger.debug("Executing command: {} with retryCount: {}", cmd.getCommand(), retryCount);
        if (retryCount >= 30) {
            this.logger.warn("Max retries reached for command: {}", cmd.getCommand());
            if (player != null) {
                player.sendMessage((Component)Component.text((String)"Max retries reached", (TextColor)NamedTextColor.YELLOW));
            }
            return;
        }
        boolean bl = shouldGateOnPlayerOnline = cmd.shouldWaitUntilPlayerIsOnline() && ("player".equalsIgnoreCase(cmd.getTargetExecutor()) || player != null && cmd.isCheckIfExecutorIsPlayer());
        if (shouldGateOnPlayerOnline && (player == null || !player.isActive())) {
            this.logger.warn("Player is not online. Retrying command: {}", cmd.getCommand());
            if (player != null) {
                player.sendMessage((Component)Component.text((String)"Player is not online. Retrying command", (TextColor)NamedTextColor.YELLOW));
            }
            this.proxy.getScheduler().buildTask((Object)this.plugin, () -> this.sendCommand(cmd, command, args, player, retryCount + 1)).delay(1L, TimeUnit.SECONDS).schedule();
            return;
        }
        List<String> targetClients = cmd.getTargetClientIds();
        if (targetClients.isEmpty()) {
            this.logger.warn("No target clients defined for command: {}", cmd.getCommand());
            if (player != null) {
                player.sendMessage((Component)Component.text((String)"No target clients are defined for this command", (TextColor)NamedTextColor.RED));
            }
            return;
        }
        for (String clientId : targetClients) {
            if (Runtime.getInstance().getServer().isServerConnected(clientId)) {
                this.logger.info("Sending command to client '{}' as {}", clientId, player == null ? "console" : (cmd.getTargetExecutor().equalsIgnoreCase("console") && cmd.isCheckIfExecutorIsPlayer() ? "console (parsed with player context)" : "player"));
                Runtime.getInstance().getServer().sendCommand(command, clientId, cmd.getTargetExecutor(), player);
                continue;
            }
            this.logger.warn("Client '{}' not found", clientId);
            if (player == null) continue;
            player.sendMessage((Component)Component.text((String)("Client '" + clientId + "' not found"), (TextColor)NamedTextColor.RED));
        }
    }
}

