/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.velocity.core;

import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.core.utils.ConfigManager;
import dev.objz.commandbridge.velocity.Main;
import dev.objz.commandbridge.velocity.command.CommandRegistrar;
import dev.objz.commandbridge.velocity.command.inbound.CommandHandler;
import dev.objz.commandbridge.velocity.command.outbound.CommandSender;
import dev.objz.commandbridge.velocity.core.Startup;
import dev.objz.commandbridge.velocity.util.Encoder;
import dev.objz.commandbridge.velocity.util.GeneralUtils;
import dev.objz.commandbridge.velocity.util.ScriptUtils;
import dev.objz.commandbridge.velocity.websocket.HttpServer;
import dev.objz.commandbridge.velocity.websocket.Server;

public class Runtime {
    private static Runtime instance;
    private Logger logger;
    private ConfigManager config;
    private ScriptUtils scriptUtils;
    private Server server;
    private Startup startup;
    private CommandSender sender;
    private CommandRegistrar registrar;
    private GeneralUtils generalUtils;
    private CommandHandler handler;
    private HttpServer httpServer;
    private Encoder encoder;

    private Runtime() {
    }

    public static synchronized Runtime getInstance() {
        if (instance == null) {
            instance = new Runtime();
            instance.getLogger().debug("Runtime singleton instance initialized.", new Object[0]);
        }
        return instance;
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger("CommandBridge");
            this.logger.debug("Logger initialized.", new Object[0]);
        }
        return this.logger;
    }

    public synchronized ConfigManager getConfig() {
        if (this.config == null) {
            this.config = new ConfigManager(this.getLogger(), "CommandBridge");
            this.getLogger().debug("ConfigManager initialized.", new Object[0]);
        }
        return this.config;
    }

    public synchronized ScriptUtils getScriptUtils() {
        if (this.scriptUtils == null) {
            this.scriptUtils = new ScriptUtils(this.getLogger(), "CommandBridge");
            this.getLogger().debug("ScriptUtils initialized.", new Object[0]);
        }
        return this.scriptUtils;
    }

    public synchronized Server getServer() {
        if (this.server == null) {
            this.server = new Server(this.getLogger(), this.getConfig().getSecret());
            this.getLogger().debug("Server initialized.", new Object[0]);
        }
        return this.server;
    }

    public synchronized Startup getStartup() {
        if (this.startup == null) {
            this.startup = new Startup(this.getLogger());
            this.getLogger().debug("Startup initialized.", new Object[0]);
        }
        return this.startup;
    }

    public synchronized CommandSender getSender() {
        if (this.sender == null) {
            this.sender = new CommandSender(this.getLogger(), Main.getInstance());
            this.getLogger().debug("CommandSender initialized.", new Object[0]);
        }
        return this.sender;
    }

    public synchronized CommandRegistrar getRegistrar() {
        if (this.registrar == null) {
            this.registrar = new CommandRegistrar(this.getLogger());
            this.getLogger().debug("InternalRegistrar initialized.", new Object[0]);
        }
        return this.registrar;
    }

    public synchronized GeneralUtils getGeneralUtils() {
        if (this.generalUtils == null) {
            this.generalUtils = new GeneralUtils(this.getLogger());
            this.getLogger().debug("GeneralUtils initialized.", new Object[0]);
        }
        return this.generalUtils;
    }

    public synchronized CommandHandler getCommandHandler() {
        if (this.handler == null) {
            this.handler = new CommandHandler();
            this.getLogger().debug("CommandHandler initialized.", new Object[0]);
        }
        return this.handler;
    }

    public synchronized HttpServer getHttpServer() {
        if (this.httpServer == null) {
            this.httpServer = new HttpServer(this.logger);
            this.getLogger().debug("HttpServer initialized.", new Object[0]);
        }
        return this.httpServer;
    }

    public synchronized Encoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new Encoder();
            this.getLogger().debug("Encoder initialized.", new Object[0]);
        }
        return this.encoder;
    }
}

