/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.velocity.helper;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.objz.commandbridge.core.Logger;
import dev.objz.commandbridge.velocity.Main;
import dev.objz.commandbridge.velocity.core.Runtime;
import dev.objz.commandbridge.velocity.util.ProxyUtils;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class DumpFailureChecker
implements Runnable {
    private static final String DUMP_API_URL = "https://cb.objz.dev/api/dump";
    private final Logger logger;
    private final ProxyServer proxy;
    private final Main plugin;
    private final CommandSource source;
    private final int maxRetries;
    private int attempt = 0;

    public DumpFailureChecker(CommandSource source, Logger logger) {
        this.source = source;
        this.logger = logger;
        this.proxy = ProxyUtils.getProxyServer();
        this.plugin = Main.getInstance();
        this.maxRetries = Integer.parseInt(Runtime.getInstance().getConfig().getKey("config.yml", "timeout"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ++this.attempt;
        this.logger.debug("Dump check attempt {}/{}", this.attempt, this.maxRetries);
        Set<String> connected = Runtime.getInstance().getServer().getConnectedClients();
        Map<String, String> scripts = Runtime.getInstance().getEncoder().getClientsScripts();
        Set missing = connected.stream().filter(client -> !scripts.containsKey(client)).collect(Collectors.toSet());
        if (missing.isEmpty()) {
            String compressed;
            String compact = Runtime.getInstance().getEncoder().encode();
            try {
                compressed = Runtime.getInstance().getEncoder().compress(compact);
            }
            catch (Exception e) {
                this.logger.error("Failed to compress aggregated dump: {}", this.logger.getDebug() != false ? e : e.getMessage());
                this.source.sendMessage(Component.text((String)"Error while compressing dump data").color((TextColor)NamedTextColor.RED));
                return;
            }
            try {
                HttpClient client2 = HttpClient.newHttpClient();
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create(DUMP_API_URL)).header("Content-Type", "text/plain").POST(HttpRequest.BodyPublishers.ofString(compressed)).build();
                HttpResponse<String> resp = client2.send(req, HttpResponse.BodyHandlers.ofString());
                int status = resp.statusCode();
                if (status == 429) {
                    this.logger.warn("Rate limit exceeded when posting dump", new Object[0]);
                    this.source.sendMessage(Component.text((String)"Rate limit exceeded, please try again later").color((TextColor)NamedTextColor.RED));
                    return;
                }
                if (status != 200) {
                    throw new IOException("HTTP " + status);
                }
                String body = resp.body().trim();
                int start = body.indexOf("\"id\":\"") + 6;
                int end = body.indexOf("\"", start);
                if (start < 6 || end < start) {
                    throw new IOException("Unexpected API response: " + body);
                }
                String id = body.substring(start, end);
                String link = "https://cb.objz.dev/dump?id=" + id;
                this.source.sendMessage(Component.text((String)"Your dump is here: ").append(((TextComponent)((TextComponent)Component.text((String)("https://cb.objz.dev/dump?id=" + id)).color((TextColor)NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)("https://cb.objz.dev/dump?id=" + id)))));
                this.logger.info("dump link: {}", link);
            }
            catch (IOException | InterruptedException e) {
                this.logger.error("Failed to POST dump to remote API: {}", e.getMessage());
                this.source.sendMessage(Component.text((String)("Failed to upload dump: " + e.getMessage())).color((TextColor)NamedTextColor.RED));
            }
            finally {
                Runtime.getInstance().getEncoder().clearClientsScripts();
            }
        } else if (this.attempt >= this.maxRetries) {
            String missingList = String.join((CharSequence)", ", missing);
            this.source.sendMessage(Component.text((String)("DumpCommand failed: missing responses from " + missingList)).color((TextColor)NamedTextColor.RED));
            this.logger.error("Dump command failed: missing responses from {}", missingList);
            Runtime.getInstance().getEncoder().clearClientsScripts();
        } else {
            this.proxy.getScheduler().buildTask((Object)this.plugin, (Runnable)this).delay(1L, TimeUnit.SECONDS).schedule();
        }
    }
}

