/*
 * Decompiled with CFR 0.152.
 */
package dev.objz.commandbridge.velocity.util;

import dev.objz.commandbridge.core.utils.ConfigManager;
import dev.objz.commandbridge.core.utils.ScriptManager;
import dev.objz.commandbridge.velocity.Main;
import dev.objz.commandbridge.velocity.core.Runtime;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class Encoder {
    private final Map<String, ScriptManager.ScriptConfig> scripts = new LinkedHashMap<String, ScriptManager.ScriptConfig>();
    private final Map<String, String> clientsScripts = new HashMap<String, String>();

    public Map<String, String> getClientsScripts() {
        return new LinkedHashMap<String, String>(this.clientsScripts);
    }

    public void clearClientsScripts() {
        this.clientsScripts.clear();
    }

    public void addScriptConfig(ScriptManager.ScriptConfig config) {
        if (config == null || config.getName() == null) {
            throw new IllegalArgumentException("ScriptConfig or name cannot be null");
        }
        this.scripts.put(config.getName(), config);
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append("V").append("/").append(System.getProperty("java.version")).append("/").append(Main.getInstance().getVelocityVersion()).append("/").append(Main.getVersion());
        ConfigManager configManager = Runtime.getInstance().getConfig();
        sb.append("&");
        sb.append(configManager.getKey("config.yml", "server-id")).append(",");
        sb.append(configManager.getKey("config.yml", "debug")).append(",");
        sb.append(configManager.getKey("config.yml", "host")).append(",");
        sb.append(configManager.getKey("config.yml", "san")).append(",");
        sb.append(configManager.getKey("config.yml", "port")).append(",");
        sb.append(configManager.getKey("config.yml", "timeout"));
        for (ScriptManager.ScriptConfig script : this.scripts.values()) {
            sb.append("@");
            sb.append(this.encodeField(script.getName())).append(",");
            sb.append(this.encodeList(script.getAliases())).append(",");
            int scriptFlags = (script.isEnabled() ? 4 : 0) | (script.shouldIgnorePermissionCheck() ? 2 : 0) | (script.shouldHidePermissionWarning() ? 1 : 0);
            sb.append(Integer.toString(scriptFlags, 36));
            for (ScriptManager.Command cmd : script.getCommands()) {
                sb.append(";");
                sb.append(this.encodeField(cmd.getCommand())).append(",");
                sb.append(cmd.getDelay()).append(",");
                sb.append(this.encodeList(cmd.getTargetClientIds())).append(",");
                sb.append(cmd.getTargetExecutor().charAt(0)).append(",");
                int cmdFlags = (cmd.shouldWaitUntilPlayerIsOnline() ? 4 : 0) | (cmd.isCheckIfExecutorIsPlayer() ? 2 : 0) | (cmd.isCheckIfExecutorIsOnServer() ? 1 : 0);
                sb.append(Integer.toString(cmdFlags, 36));
            }
        }
        return sb.toString();
    }

    public void addClient(String clientId, String encodedString) {
        if (clientId == null || clientId.isEmpty() || encodedString == null || encodedString.isEmpty()) {
            throw new IllegalArgumentException("Client ID and encoded string cannot be null or empty");
        }
        this.clientsScripts.put(clientId, encodedString);
    }

    public String compress(String input) {
        byte[] raw = input.getBytes(StandardCharsets.UTF_8);
        byte[] packed = this.gzip(raw);
        String base64 = Base64.getUrlEncoder().withoutPadding().encodeToString(packed);
        StringBuilder sb = new StringBuilder(base64);
        for (Map.Entry<String, String> entry : this.clientsScripts.entrySet()) {
            sb.append('#').append(entry.getKey()).append(',').append(entry.getValue());
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] gzip(byte[] data) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
                gos.write(data);
                gos.finish();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException("GZIP compression failed", e);
        }
    }

    private String encodeField(String value) {
        if (value == null || value.isEmpty()) {
            return ".";
        }
        return value.replace(",", "\\,").replace(";", "\\;");
    }

    private String encodeList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return ".";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            sb.append(this.encodeField(it.next()));
            if (!it.hasNext()) continue;
            sb.append("|");
        }
        return sb.toString();
    }
}

