/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http3;

import io.netty.handler.codec.http3.Http3CodecUtils;
import io.netty.handler.codec.http3.Http3SettingsFrame;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import io.netty.util.internal.StringUtil;
import java.util.Iterator;
import java.util.Map;

public final class DefaultHttp3SettingsFrame
implements Http3SettingsFrame {
    private final LongObjectMap<Long> settings = new LongObjectHashMap<Long>(4);

    @Override
    public Long get(long key) {
        return this.settings.get(key);
    }

    @Override
    public Long put(long key, Long value) {
        if (Http3CodecUtils.isReservedHttp2Setting(key)) {
            throw new IllegalArgumentException("Setting is reserved for HTTP/2: " + key);
        }
        return this.settings.put(key, value);
    }

    @Override
    public Iterator<Map.Entry<Long, Long>> iterator() {
        return this.settings.entrySet().iterator();
    }

    public int hashCode() {
        return this.settings.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultHttp3SettingsFrame that = (DefaultHttp3SettingsFrame)o;
        return that.settings.equals(this.settings);
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(settings=" + this.settings + ')';
    }

    public static DefaultHttp3SettingsFrame copyOf(Http3SettingsFrame settingsFrame) {
        DefaultHttp3SettingsFrame copy = new DefaultHttp3SettingsFrame();
        if (settingsFrame instanceof DefaultHttp3SettingsFrame) {
            copy.settings.putAll(((DefaultHttp3SettingsFrame)settingsFrame).settings);
        } else {
            for (Map.Entry entry : settingsFrame) {
                copy.put((Long)entry.getKey(), (Long)entry.getValue());
            }
        }
        return copy;
    }
}

