/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.mqtt.MqttCodecUtil;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttIdentifierRejectedException;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubAckPayload;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.List;

public final class MqttDecoder
extends ReplayingDecoder<DecoderState> {
    private MqttFixedHeader mqttFixedHeader;
    private Object variableHeader;
    private int bytesRemainingInVariablePart;
    private final int maxBytesInMessage;
    private final int maxClientIdLength;

    public MqttDecoder() {
        this(8092, 23);
    }

    public MqttDecoder(int maxBytesInMessage) {
        this(maxBytesInMessage, 23);
    }

    public MqttDecoder(int maxBytesInMessage, int maxClientIdLength) {
        super(DecoderState.READ_FIXED_HEADER);
        this.maxBytesInMessage = ObjectUtil.checkPositive(maxBytesInMessage, "maxBytesInMessage");
        this.maxClientIdLength = ObjectUtil.checkPositive(maxClientIdLength, "maxClientIdLength");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        switch ((DecoderState)((Object)this.state())) {
            case READ_FIXED_HEADER: {
                try {
                    this.mqttFixedHeader = MqttDecoder.decodeFixedHeader(ctx, buffer);
                    this.bytesRemainingInVariablePart = this.mqttFixedHeader.remainingLength();
                    this.checkpoint(DecoderState.READ_VARIABLE_HEADER);
                }
                catch (Exception cause) {
                    out.add(this.invalidMessage(cause));
                    return;
                }
            }
            case READ_VARIABLE_HEADER: {
                try {
                    int bytesRemainingBeforeVariableHeader = this.bytesRemainingInVariablePart;
                    this.variableHeader = this.decodeVariableHeader(ctx, buffer, this.mqttFixedHeader);
                    if (bytesRemainingBeforeVariableHeader > this.maxBytesInMessage) {
                        buffer.skipBytes(this.actualReadableBytes());
                        throw new TooLongFrameException("message length exceeds " + this.maxBytesInMessage + ": " + bytesRemainingBeforeVariableHeader);
                    }
                    this.checkpoint(DecoderState.READ_PAYLOAD);
                }
                catch (Exception cause) {
                    out.add(this.invalidMessage(cause));
                    return;
                }
            }
            case READ_PAYLOAD: {
                try {
                    Object decodedPayload = this.decodePayload(ctx, buffer, this.mqttFixedHeader.messageType(), this.maxClientIdLength, this.variableHeader);
                    this.checkpoint(DecoderState.READ_FIXED_HEADER);
                    MqttMessage message = MqttMessageFactory.newMessage(this.mqttFixedHeader, this.variableHeader, decodedPayload);
                    this.mqttFixedHeader = null;
                    this.variableHeader = null;
                    out.add(message);
                    break;
                }
                catch (Exception cause) {
                    out.add(this.invalidMessage(cause));
                    return;
                }
            }
            case BAD_MESSAGE: {
                buffer.skipBytes(this.actualReadableBytes());
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private MqttMessage invalidMessage(Throwable cause) {
        this.checkpoint(DecoderState.BAD_MESSAGE);
        return MqttMessageFactory.newInvalidMessage(this.mqttFixedHeader, this.variableHeader, cause);
    }

    private static MqttFixedHeader decodeFixedHeader(ChannelHandlerContext ctx, ByteBuf buffer) {
        short b1 = buffer.readUnsignedByte();
        MqttMessageType messageType = MqttMessageType.valueOf(b1 >> 4);
        boolean dupFlag = (b1 & 8) == 8;
        int qosLevel = (b1 & 6) >> 1;
        boolean retain = (b1 & 1) != 0;
        switch (messageType) {
            case PUBLISH: {
                if (qosLevel != 3) break;
                throw new DecoderException("Illegal QOS Level in fixed header of PUBLISH message (" + qosLevel + ')');
            }
            case PUBREL: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                if (dupFlag) {
                    throw new DecoderException("Illegal BIT 3 in fixed header of " + (Object)((Object)messageType) + " message, must be 0, found 1");
                }
                if (qosLevel != 1) {
                    throw new DecoderException("Illegal QOS Level in fixed header of " + (Object)((Object)messageType) + " message, must be 1, found " + qosLevel);
                }
                if (!retain) break;
                throw new DecoderException("Illegal BIT 0 in fixed header of " + (Object)((Object)messageType) + " message, must be 0, found 1");
            }
            case AUTH: 
            case CONNACK: 
            case CONNECT: 
            case DISCONNECT: 
            case PINGREQ: 
            case PINGRESP: 
            case PUBACK: 
            case PUBCOMP: 
            case PUBREC: 
            case SUBACK: 
            case UNSUBACK: {
                if (dupFlag) {
                    throw new DecoderException("Illegal BIT 3 in fixed header of " + (Object)((Object)messageType) + " message, must be 0, found 1");
                }
                if (qosLevel != 0) {
                    throw new DecoderException("Illegal BIT 2 or 1 in fixed header of " + (Object)((Object)messageType) + " message, must be 0, found " + qosLevel);
                }
                if (!retain) break;
                throw new DecoderException("Illegal BIT 0 in fixed header of " + (Object)((Object)messageType) + " message, must be 0, found 1");
            }
            default: {
                throw new DecoderException("Unknown message type, do not know how to validate fixed header");
            }
        }
        int remainingLength = MqttDecoder.parseRemainingLength(buffer, messageType);
        MqttFixedHeader decodedFixedHeader = new MqttFixedHeader(messageType, dupFlag, MqttQoS.valueOf(qosLevel), retain, remainingLength);
        return MqttCodecUtil.validateFixedHeader(ctx, MqttCodecUtil.resetUnusedFields(decodedFixedHeader));
    }

    private static int parseRemainingLength(ByteBuf buffer, MqttMessageType messageType) {
        int remainingLength = 0;
        int multiplier = 1;
        for (int i = 0; i < 4; ++i) {
            short digit = buffer.readUnsignedByte();
            remainingLength += (digit & 0x7F) * multiplier;
            if ((digit & 0x80) == 0) {
                return remainingLength;
            }
            multiplier *= 128;
        }
        throw new DecoderException("remaining length exceeds 4 digits (" + (Object)((Object)messageType) + ')');
    }

    private Object decodeVariableHeader(ChannelHandlerContext ctx, ByteBuf buffer, MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return this.decodeConnectionVariableHeader(ctx, buffer);
            }
            case CONNACK: {
                return this.decodeConnAckVariableHeader(ctx, buffer);
            }
            case SUBSCRIBE: 
            case UNSUBSCRIBE: 
            case SUBACK: 
            case UNSUBACK: {
                return this.decodeMessageIdAndPropertiesVariableHeader(ctx, buffer);
            }
            case PUBREL: 
            case PUBACK: 
            case PUBCOMP: 
            case PUBREC: {
                return this.decodePubReplyMessage(buffer);
            }
            case PUBLISH: {
                return this.decodePublishVariableHeader(ctx, buffer, mqttFixedHeader);
            }
            case AUTH: 
            case DISCONNECT: {
                return this.decodeReasonCodeAndPropertiesVariableHeader(buffer);
            }
            case PINGREQ: 
            case PINGRESP: {
                return null;
            }
        }
        throw new DecoderException("Unknown message type: " + (Object)((Object)mqttFixedHeader.messageType()));
    }

    private MqttConnectVariableHeader decodeConnectionVariableHeader(ChannelHandlerContext ctx, ByteBuf buffer) {
        boolean cleanSession;
        String protoString = this.decodeStringAndDecreaseBytesRemaining(buffer);
        byte protocolLevel = buffer.readByte();
        MqttVersion version = MqttVersion.fromProtocolNameAndLevel(protoString, protocolLevel);
        MqttCodecUtil.setMqttVersion(ctx, version);
        short b1 = buffer.readUnsignedByte();
        int keepAlive = MqttDecoder.decodeMsbLsb(buffer);
        boolean hasUserName = (b1 & 0x80) == 128;
        boolean hasPassword = (b1 & 0x40) == 64;
        boolean willRetain = (b1 & 0x20) == 32;
        int willQos = (b1 & 0x18) >> 3;
        boolean willFlag = (b1 & 4) == 4;
        boolean bl = cleanSession = (b1 & 2) == 2;
        if (version == MqttVersion.MQTT_3_1_1 || version == MqttVersion.MQTT_5) {
            boolean zeroReservedFlag;
            boolean bl2 = zeroReservedFlag = (b1 & 1) == 0;
            if (!zeroReservedFlag) {
                throw new DecoderException("non-zero reserved flag");
            }
        }
        MqttProperties properties = version == MqttVersion.MQTT_5 ? this.decodeProperties(buffer) : MqttProperties.NO_PROPERTIES;
        this.bytesRemainingInVariablePart -= 4;
        return new MqttConnectVariableHeader(version.protocolName(), version.protocolLevel(), hasUserName, hasPassword, willRetain, willQos, willFlag, cleanSession, keepAlive, properties);
    }

    private MqttConnAckVariableHeader decodeConnAckVariableHeader(ChannelHandlerContext ctx, ByteBuf buffer) {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        boolean sessionPresent = (buffer.readUnsignedByte() & 1) == 1;
        byte returnCode = buffer.readByte();
        this.bytesRemainingInVariablePart -= 2;
        MqttProperties properties = mqttVersion == MqttVersion.MQTT_5 ? this.decodeProperties(buffer) : MqttProperties.NO_PROPERTIES;
        return new MqttConnAckVariableHeader(MqttConnectReturnCode.valueOf(returnCode), sessionPresent, properties);
    }

    private MqttMessageIdAndPropertiesVariableHeader decodeMessageIdAndPropertiesVariableHeader(ChannelHandlerContext ctx, ByteBuf buffer) {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        int packetId = MqttDecoder.decodeMessageId(buffer);
        this.bytesRemainingInVariablePart -= 2;
        MqttProperties properties = mqttVersion == MqttVersion.MQTT_5 ? this.decodeProperties(buffer) : MqttProperties.NO_PROPERTIES;
        return new MqttMessageIdAndPropertiesVariableHeader(packetId, properties);
    }

    private MqttPubReplyMessageVariableHeader decodePubReplyMessage(ByteBuf buffer) {
        int packetId = MqttDecoder.decodeMessageId(buffer);
        int packetIdNumberOfBytesConsumed = 2;
        if (this.bytesRemainingInVariablePart > 3) {
            byte reasonCode = buffer.readByte();
            MqttProperties properties = this.decodeProperties(buffer);
            this.bytesRemainingInVariablePart -= 3;
            return new MqttPubReplyMessageVariableHeader(packetId, reasonCode, properties);
        }
        if (this.bytesRemainingInVariablePart > 2) {
            byte reasonCode = buffer.readByte();
            this.bytesRemainingInVariablePart -= 3;
            return new MqttPubReplyMessageVariableHeader(packetId, reasonCode, MqttProperties.NO_PROPERTIES);
        }
        this.bytesRemainingInVariablePart -= 2;
        return new MqttPubReplyMessageVariableHeader(packetId, 0, MqttProperties.NO_PROPERTIES);
    }

    private MqttReasonCodeAndPropertiesVariableHeader decodeReasonCodeAndPropertiesVariableHeader(ByteBuf buffer) {
        MqttProperties properties;
        byte reasonCode;
        if (this.bytesRemainingInVariablePart > 1) {
            reasonCode = buffer.readByte();
            properties = this.decodeProperties(buffer);
            --this.bytesRemainingInVariablePart;
        } else if (this.bytesRemainingInVariablePart > 0) {
            reasonCode = buffer.readByte();
            properties = MqttProperties.NO_PROPERTIES;
            --this.bytesRemainingInVariablePart;
        } else {
            reasonCode = 0;
            properties = MqttProperties.NO_PROPERTIES;
        }
        return new MqttReasonCodeAndPropertiesVariableHeader(reasonCode, properties);
    }

    private MqttPublishVariableHeader decodePublishVariableHeader(ChannelHandlerContext ctx, ByteBuf buffer, MqttFixedHeader mqttFixedHeader) {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        String decodedTopic = this.decodeStringAndDecreaseBytesRemaining(buffer);
        if (!MqttCodecUtil.isValidPublishTopicName(decodedTopic)) {
            throw new DecoderException("invalid publish topic name: " + decodedTopic + " (contains wildcards)");
        }
        int messageId = -1;
        if (mqttFixedHeader.qosLevel().value() > 0) {
            messageId = MqttDecoder.decodeMessageId(buffer);
            this.bytesRemainingInVariablePart -= 2;
        }
        MqttProperties properties = mqttVersion == MqttVersion.MQTT_5 ? this.decodeProperties(buffer) : MqttProperties.NO_PROPERTIES;
        return new MqttPublishVariableHeader(decodedTopic, messageId, properties);
    }

    private static int decodeMessageId(ByteBuf buffer) {
        int messageId = MqttDecoder.decodeMsbLsb(buffer);
        if (!MqttCodecUtil.isValidMessageId(messageId)) {
            throw new DecoderException("invalid messageId: " + messageId);
        }
        return messageId;
    }

    private Object decodePayload(ChannelHandlerContext ctx, ByteBuf buffer, MqttMessageType messageType, int maxClientIdLength, Object variableHeader) {
        switch (messageType) {
            case CONNECT: {
                return this.decodeConnectionPayload(buffer, maxClientIdLength, (MqttConnectVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return this.decodeSubscribePayload(buffer);
            }
            case SUBACK: {
                return this.decodeSubackPayload(buffer);
            }
            case UNSUBSCRIBE: {
                return this.decodeUnsubscribePayload(buffer);
            }
            case UNSUBACK: {
                return this.decodeUnsubAckPayload(ctx, buffer);
            }
            case PUBLISH: {
                return this.decodePublishPayload(buffer);
            }
        }
        return null;
    }

    private MqttConnectPayload decodeConnectionPayload(ByteBuf buffer, int maxClientIdLength, MqttConnectVariableHeader mqttConnectVariableHeader) {
        MqttProperties willProperties;
        String decodedClientId = this.decodeStringAndDecreaseBytesRemaining(buffer);
        MqttVersion mqttVersion = MqttVersion.fromProtocolNameAndLevel(mqttConnectVariableHeader.name(), (byte)mqttConnectVariableHeader.version());
        if (!MqttCodecUtil.isValidClientId(mqttVersion, maxClientIdLength, decodedClientId)) {
            throw new MqttIdentifierRejectedException("invalid clientIdentifier: " + decodedClientId);
        }
        String decodedWillTopic = null;
        byte[] decodedWillMessage = null;
        int numberOfBytesConsumed = 0;
        if (mqttConnectVariableHeader.isWillFlag()) {
            willProperties = mqttVersion == MqttVersion.MQTT_5 ? this.decodeProperties(buffer) : MqttProperties.NO_PROPERTIES;
            int willTopicSize = MqttDecoder.decodeMsbLsb(buffer);
            numberOfBytesConsumed += 2 + willTopicSize;
            if (willTopicSize <= Short.MAX_VALUE) {
                decodedWillTopic = buffer.readString(willTopicSize, CharsetUtil.UTF_8);
            } else {
                buffer.skipBytes(willTopicSize);
            }
            decodedWillMessage = MqttDecoder.decodeByteArray(buffer);
            numberOfBytesConsumed += decodedWillMessage.length + 2;
        } else {
            willProperties = MqttProperties.NO_PROPERTIES;
        }
        String decodedUserName = null;
        byte[] decodedPassword = null;
        if (mqttConnectVariableHeader.hasUserName()) {
            decodedUserName = this.decodeStringAndDecreaseBytesRemaining(buffer);
        }
        if (mqttConnectVariableHeader.hasPassword()) {
            decodedPassword = MqttDecoder.decodeByteArray(buffer);
            numberOfBytesConsumed += decodedPassword.length + 2;
        }
        this.validateNoBytesRemain(numberOfBytesConsumed);
        return new MqttConnectPayload(decodedClientId, willProperties, decodedWillTopic, decodedWillMessage, decodedUserName, decodedPassword);
    }

    private MqttSubscribePayload decodeSubscribePayload(ByteBuf buffer) {
        int numberOfBytesConsumed;
        ArrayList<MqttTopicSubscription> subscribeTopics = new ArrayList<MqttTopicSubscription>();
        for (numberOfBytesConsumed = 0; numberOfBytesConsumed < this.bytesRemainingInVariablePart; ++numberOfBytesConsumed) {
            int topicNameSize = MqttDecoder.decodeMsbLsb(buffer);
            String decodedTopicName = buffer.readString(topicNameSize, CharsetUtil.UTF_8);
            numberOfBytesConsumed += 2 + topicNameSize;
            short optionByte = buffer.readUnsignedByte();
            MqttQoS qos = MqttQoS.valueOf(optionByte & 3);
            boolean noLocal = (optionByte & 4) >> 2 == 1;
            boolean retainAsPublished = (optionByte & 8) >> 3 == 1;
            MqttSubscriptionOption.RetainedHandlingPolicy retainHandling = MqttSubscriptionOption.RetainedHandlingPolicy.valueOf((optionByte & 0x30) >> 4);
            MqttSubscriptionOption subscriptionOption = new MqttSubscriptionOption(qos, noLocal, retainAsPublished, retainHandling);
            subscribeTopics.add(new MqttTopicSubscription(decodedTopicName, subscriptionOption));
        }
        this.validateNoBytesRemain(numberOfBytesConsumed);
        return new MqttSubscribePayload(subscribeTopics);
    }

    private MqttSubAckPayload decodeSubackPayload(ByteBuf buffer) {
        int numberOfBytesConsumed;
        int bytesRemainingInVariablePart = this.bytesRemainingInVariablePart;
        ArrayList<Integer> grantedQos = new ArrayList<Integer>(bytesRemainingInVariablePart);
        for (numberOfBytesConsumed = 0; numberOfBytesConsumed < bytesRemainingInVariablePart; ++numberOfBytesConsumed) {
            short reasonCode = buffer.readUnsignedByte();
            grantedQos.add(Integer.valueOf(reasonCode));
        }
        this.validateNoBytesRemain(numberOfBytesConsumed);
        return new MqttSubAckPayload(grantedQos);
    }

    private MqttUnsubAckPayload decodeUnsubAckPayload(ChannelHandlerContext ctx, ByteBuf buffer) {
        int numberOfBytesConsumed;
        int bytesRemainingInVariablePart = this.bytesRemainingInVariablePart;
        ArrayList<Short> reasonCodes = new ArrayList<Short>(bytesRemainingInVariablePart);
        for (numberOfBytesConsumed = 0; numberOfBytesConsumed < bytesRemainingInVariablePart; ++numberOfBytesConsumed) {
            short reasonCode = buffer.readUnsignedByte();
            reasonCodes.add(reasonCode);
        }
        this.validateNoBytesRemain(numberOfBytesConsumed);
        return new MqttUnsubAckPayload(reasonCodes);
    }

    private MqttUnsubscribePayload decodeUnsubscribePayload(ByteBuf buffer) {
        ArrayList<String> unsubscribeTopics = new ArrayList<String>();
        while (this.bytesRemainingInVariablePart > 0) {
            String decodedTopicName = this.decodeStringAndDecreaseBytesRemaining(buffer);
            unsubscribeTopics.add(decodedTopicName);
        }
        return new MqttUnsubscribePayload(unsubscribeTopics);
    }

    private ByteBuf decodePublishPayload(ByteBuf buffer) {
        return buffer.readRetainedSlice(this.bytesRemainingInVariablePart);
    }

    private void validateNoBytesRemain(int numberOfBytesConsumed) {
        this.bytesRemainingInVariablePart -= numberOfBytesConsumed;
        if (this.bytesRemainingInVariablePart != 0) {
            throw new DecoderException("non-zero remaining payload bytes: " + this.bytesRemainingInVariablePart + " (" + (Object)((Object)this.mqttFixedHeader.messageType()) + ')');
        }
    }

    private String decodeStringAndDecreaseBytesRemaining(ByteBuf buffer) {
        int size = MqttDecoder.decodeMsbLsb(buffer);
        this.bytesRemainingInVariablePart -= 2 + size;
        return buffer.readString(size, CharsetUtil.UTF_8);
    }

    private static byte[] decodeByteArray(ByteBuf buffer) {
        int size = MqttDecoder.decodeMsbLsb(buffer);
        byte[] bytes = new byte[size];
        buffer.readBytes(bytes);
        return bytes;
    }

    private static long packInts(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    private static int unpackA(long ints) {
        return (int)(ints >> 32);
    }

    private static int unpackB(long ints) {
        return (int)ints;
    }

    private static int decodeMsbLsb(ByteBuf buffer) {
        short lsbSize;
        int min = 0;
        int max = 65535;
        short msbSize = buffer.readUnsignedByte();
        int result = msbSize << 8 | (lsbSize = buffer.readUnsignedByte());
        if (result < min || result > max) {
            result = -1;
        }
        return result;
    }

    private static long decodeVariableByteInteger(ByteBuf buffer) {
        int remainingLength = 0;
        int multiplier = 1;
        for (int i = 0; i < 4; ++i) {
            short digit = buffer.readUnsignedByte();
            remainingLength += (digit & 0x7F) * multiplier;
            if ((digit & 0x80) == 0) {
                return MqttDecoder.packInts(remainingLength, i + 1);
            }
            multiplier *= 128;
        }
        throw new DecoderException("MQTT protocol limits Remaining Length to 4 bytes");
    }

    private MqttProperties decodeProperties(ByteBuf buffer) {
        long propertiesLength = MqttDecoder.decodeVariableByteInteger(buffer);
        int totalPropertiesLength = MqttDecoder.unpackA(propertiesLength);
        int numberOfBytesConsumed = MqttDecoder.unpackB(propertiesLength);
        MqttProperties decodedProperties = new MqttProperties();
        block9: while (numberOfBytesConsumed < totalPropertiesLength) {
            long propertyId = MqttDecoder.decodeVariableByteInteger(buffer);
            int propertyIdValue = MqttDecoder.unpackA(propertyId);
            numberOfBytesConsumed += MqttDecoder.unpackB(propertyId);
            switch (propertyIdValue) {
                case 1: 
                case 23: 
                case 25: 
                case 36: 
                case 37: 
                case 40: 
                case 41: 
                case 42: {
                    short b1 = buffer.readUnsignedByte();
                    ++numberOfBytesConsumed;
                    decodedProperties.add(new MqttProperties.IntegerProperty(propertyIdValue, Integer.valueOf(b1)));
                    continue block9;
                }
                case 19: 
                case 33: 
                case 34: 
                case 35: {
                    int int2BytesResult = MqttDecoder.decodeMsbLsb(buffer);
                    numberOfBytesConsumed += 2;
                    decodedProperties.add(new MqttProperties.IntegerProperty(propertyIdValue, int2BytesResult));
                    continue block9;
                }
                case 2: 
                case 17: 
                case 24: 
                case 39: {
                    int maxPacketSize = buffer.readInt();
                    numberOfBytesConsumed += 4;
                    decodedProperties.add(new MqttProperties.IntegerProperty(propertyIdValue, maxPacketSize));
                    continue block9;
                }
                case 11: {
                    long vbIntegerResult = MqttDecoder.decodeVariableByteInteger(buffer);
                    numberOfBytesConsumed += MqttDecoder.unpackB(vbIntegerResult);
                    decodedProperties.add(new MqttProperties.IntegerProperty(propertyIdValue, MqttDecoder.unpackA(vbIntegerResult)));
                    continue block9;
                }
                case 3: 
                case 8: 
                case 18: 
                case 21: 
                case 26: 
                case 28: 
                case 31: {
                    int size = MqttDecoder.decodeMsbLsb(buffer);
                    numberOfBytesConsumed += 2 + size;
                    String string = buffer.readString(size, CharsetUtil.UTF_8);
                    decodedProperties.add(new MqttProperties.StringProperty(propertyIdValue, string));
                    continue block9;
                }
                case 38: {
                    int keySize = MqttDecoder.decodeMsbLsb(buffer);
                    String key = buffer.readString(keySize, CharsetUtil.UTF_8);
                    int valueSize = MqttDecoder.decodeMsbLsb(buffer);
                    String value = buffer.readString(valueSize, CharsetUtil.UTF_8);
                    numberOfBytesConsumed += 4 + keySize + valueSize;
                    decodedProperties.add(new MqttProperties.UserProperty(key, value));
                    continue block9;
                }
                case 9: 
                case 22: {
                    byte[] binaryDataResult = MqttDecoder.decodeByteArray(buffer);
                    numberOfBytesConsumed += binaryDataResult.length + 2;
                    decodedProperties.add(new MqttProperties.BinaryProperty(propertyIdValue, binaryDataResult));
                    continue block9;
                }
            }
            throw new DecoderException("Unknown property type: " + propertyIdValue);
        }
        this.bytesRemainingInVariablePart -= numberOfBytesConsumed;
        return decodedProperties;
    }

    static enum DecoderState {
        READ_FIXED_HEADER,
        READ_VARIABLE_HEADER,
        READ_PAYLOAD,
        BAD_MESSAGE;

    }
}

