/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.client.toast;

import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.joml.Vector2i;
import org.lilbrocodes.composer_reloaded.ComposerReloaded;
import org.lilbrocodes.composer_reloaded.api.render.ToastDrawUtils;
import org.lilbrocodes.composer_reloaded.api.toast.AbstractToast;
import org.lilbrocodes.theatrical.util.Misc;

public class CountdownToast
extends AbstractToast {
    private static final int HEIGHT = 40;
    private static final int MAX_WIDTH = 60;
    private static final int ICON_SIZE = 30;
    private static final int MARGIN = 20;
    private static final class_2960 ICON_TEXTURE = ComposerReloaded.identify((String)"textures/gui/toast/attention.png");
    private static final long FADE_TIME = 500L;
    private static final long START_NOTIFICATION_MS = 500L;
    private final int tickDuration;
    private final int msCountdownDuration;
    private final int msTotalDuration;
    private int lastSoundSecond = -1;

    public CountdownToast(int duration) {
        this.tickDuration = duration + 20;
        this.msCountdownDuration = this.tickDuration * 50;
        this.msTotalDuration = this.msCountdownDuration + 500;
    }

    protected void draw(class_332 context, long timeAlive, int x, int y) {
        float scaleX = this.getHorizontalScaleFactor(timeAlive);
        int currentSecond = (int)(timeAlive / 1000L);
        if (currentSecond != this.lastSoundSecond && timeAlive <= (long)this.msCountdownDuration) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15224, (float)1.0f));
            this.lastSoundSecond = currentSecond;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)x, (float)y, 0.0f);
        context.method_51448().method_22905(scaleX, 1.0f, 1.0f);
        this.drawBox(context, timeAlive);
        this.drawText(context, timeAlive);
        this.drawIcon(context);
        context.method_51448().method_22909();
        if (timeAlive >= (long)this.msTotalDuration || class_310.method_1551().field_1687 == null) {
            this.remove();
        }
    }

    private void drawText(class_332 ctx, long timeAlive) {
        int tickProgress;
        int remainingTicks;
        int wrapWidth = Math.max(10, 40);
        class_5250 message = timeAlive >= (long)this.msCountdownDuration ? class_2561.method_43471((String)"theatrical.toast.countdown.done").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}) : ((remainingTicks = this.tickDuration - (tickProgress = (int)((double)timeAlive * 0.02)) - 20) <= 0 ? class_2561.method_43471((String)"theatrical.toast.countdown.done").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}) : class_2561.method_43470((String)String.format("%.1f", (double)remainingTicks / 20.0)));
        List lines = this.textRenderer.method_1728((class_5348)message, wrapWidth);
        int wrappedHeight = this.textRenderer.method_44378((class_5348)message, wrapWidth);
        ToastDrawUtils.drawCenteredLines((class_332)ctx, (class_327)this.textRenderer, (List)lines, (int)6, (int)0, (int)wrappedHeight, (int)-1);
    }

    private void drawIcon(class_332 ctx) {
        int x = -35;
        int y = -15;
        ctx.method_25290(ICON_TEXTURE, x, y, 0.0f, 0.0f, 30, 30, 30, 30);
    }

    private void drawBox(class_332 ctx, long timeAlive) {
        int tickProgress = (int)((double)timeAlive * 0.02);
        ToastDrawUtils.drawCenteredBox((class_332)ctx, (int)0, (int)0, (int)60, (int)40, (int)Misc.mixProgressDarkColor((int)((double)this.msTotalDuration * 0.02), tickProgress));
        ToastDrawUtils.drawCenteredOutline((class_332)ctx, (int)0, (int)0, (int)60, (int)40, (int)Misc.mixProgressColor((int)((double)this.msTotalDuration * 0.02), tickProgress), (int)1);
    }

    private float getHorizontalScaleFactor(long timeAlive) {
        if (timeAlive < 500L) {
            float t = (float)timeAlive / 500.0f;
            return 1.0f - (float)Math.pow(1.0f - t, 3.0);
        }
        if (timeAlive > (long)this.msTotalDuration - 500L) {
            float t = (float)(timeAlive - ((long)this.msTotalDuration - 500L)) / 500.0f;
            return 1.0f - (1.0f - (float)Math.pow(1.0f - t, 3.0));
        }
        return 1.0f;
    }

    protected Vector2i size() {
        return new Vector2i(60, 40);
    }

    protected int margin() {
        return 20;
    }
}

