/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.lilbrocodes.theatrical.cca.TheatricalCardinalComponents;
import org.lilbrocodes.theatrical.cca.entity.VisualisedScenesComponent;
import org.lilbrocodes.theatrical.cca.world.CountdownAttemptHolderComponent;
import org.lilbrocodes.theatrical.cca.world.SceneHolderComponent;
import org.lilbrocodes.theatrical.commands.CommandUtil;
import org.lilbrocodes.theatrical.scene.Scene;
import org.lilbrocodes.theatrical.util.Misc;
import org.lilbrocodes.theatrical.util.TextUtil;

public class SceneCommand
extends CommandUtil {
    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"scene").requires(Misc::isDirector)).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"lock", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"loadStates", (ArgumentType)BoolArgumentType.bool()).executes(this::createScene)))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).executes(this::removeScene)))).then(class_2170.method_9247((String)"edit").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9247((String)"lock").then(class_2170.method_9244((String)"lock", (ArgumentType)BoolArgumentType.bool()).executes(this::editLock)))).then(this.addOrMove("add"))).then(this.addOrMove("move"))))).then(class_2170.method_9247((String)"setup").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).executes(this::setupScene)))).then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).executes(this::startScene)))).then(class_2170.method_9247((String)"countdown").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3600)).executes(this::startCountdown))))).then(class_2170.method_9247((String)"state").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9247((String)"save").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::saveState)))).then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(this::loadState)))))).then(class_2170.method_9247((String)"visuals").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9247((String)"on").executes(ctx -> this.toggleVisuals((CommandContext<class_2168>)ctx, true)))).then(class_2170.method_9247((String)"off").executes(ctx -> this.toggleVisuals((CommandContext<class_2168>)ctx, false)))))).then(class_2170.method_9247((String)"trust").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::toggleTrust)))));
    }

    private int createScene(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String name = (String)ctx.getArgument("name", String.class);
        boolean lock = (Boolean)ctx.getArgument("lock", Boolean.class);
        boolean loadStates = (Boolean)ctx.getArgument("loadStates", Boolean.class);
        Scene scene = new Scene(player.method_37908(), player.method_5667(), lock, loadStates);
        ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.put(name, scene);
        ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).sync();
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.created"));
        return 1;
    }

    private int removeScene(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String name;
        Scene scene;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name = (String)ctx.getArgument("name", String.class)))) {
            return 0;
        }
        ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.remove(name);
        ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).sync();
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43469((String)"theatrical.scene.removed", (Object[])new Object[]{name}).method_27692(class_124.field_1060));
        return 1;
    }

    private int editLock(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String name = (String)ctx.getArgument("name", String.class);
        boolean lock = (Boolean)ctx.getArgument("lock", Boolean.class);
        Scene scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name);
        if (this.checkScenePerms((class_1657)player, scene)) {
            return 0;
        }
        scene.setLock(lock);
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.edit.success"));
        return 1;
    }

    private CompletableFuture<Suggestions> scenes(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }

    private boolean checkScenePerms(class_1657 player, Scene scene) {
        if (scene == null) {
            SceneCommand.feedback(player, (class_2561)class_2561.method_43471((String)"theatrical.scene.edit.not_exists").method_27692(class_124.field_1061));
            return true;
        }
        if (!scene.hasPermission(player.method_5667())) {
            SceneCommand.feedback(player, (class_2561)class_2561.method_43471((String)"theatrical.scene.edit.no_permission").method_27692(class_124.field_1061));
            return true;
        }
        return false;
    }

    private LiteralArgumentBuilder<class_2168> addOrMove(String type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)type).then(class_2170.method_9247((String)"pos").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.executeAddMove((CommandContext<class_2168>)ctx, type, true, null, null))))).then(class_2170.method_9247((String)"coords").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(ctx -> this.executeAddMove((CommandContext<class_2168>)ctx, type, false, class_2277.method_9736((CommandContext)ctx, (String)"pos"), null))).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(ctx -> this.executeAddMove((CommandContext<class_2168>)ctx, type, false, class_2277.method_9736((CommandContext)ctx, (String)"pos"), class_2270.method_9716((CommandContext)ctx, (String)"rotation").method_9709((class_2168)ctx.getSource())))))));
    }

    private int executeAddMove(CommandContext<class_2168> ctx, String type, boolean usePlayerPos, class_243 pos, class_241 rot) throws CommandSyntaxException {
        boolean success;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String name = (String)ctx.getArgument("name", String.class);
        class_3222 target = class_2186.method_9315(ctx, (String)"player");
        Scene scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name);
        if (this.checkScenePerms((class_1657)player, scene)) {
            return 0;
        }
        if (usePlayerPos) {
            pos = target.method_19538();
            rot = new class_241(target.method_36454(), target.method_36455());
        }
        if (type.equals("add")) {
            success = scene.add(target.method_5667(), pos, rot.field_1343, rot.field_1342);
        } else {
            scene.move(target.method_5667(), pos, rot != null ? rot.field_1343 : 0.0f, rot != null ? rot.field_1342 : 0.0f);
            success = true;
        }
        if (!success) {
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.add.already_exists"));
            return 0;
        }
        TheatricalCardinalComponents.SCENES.sync((Object)player.method_37908());
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)(type.equals("add") ? "theatrical.scene.add.success" : "theatrical.scene.move.success")));
        return 1;
    }

    private int setupScene(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String name;
        Scene scene;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name = (String)ctx.getArgument("name", String.class)))) {
            return 0;
        }
        scene.setup();
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.setup"));
        return 1;
    }

    private int startScene(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String name;
        Scene scene;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name = (String)ctx.getArgument("name", String.class)))) {
            return 0;
        }
        scene.start();
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.start"));
        return 1;
    }

    private int startCountdown(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String name = (String)ctx.getArgument("name", String.class);
        int duration = (Integer)ctx.getArgument("duration", Integer.class) * 20;
        Scene scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name);
        if (this.checkScenePerms((class_1657)player, scene)) {
            return 0;
        }
        List<UUID> actors = scene.actors();
        ((CountdownAttemptHolderComponent)TheatricalCardinalComponents.COUNTDOWN_ATTEMPTS.get((Object)player.method_37908())).create(player.method_5667(), actors, duration);
        SceneCommand.feedback(ctx, TextUtil.replaceTranslatable("command.theatrical.countdown.success", duration, actors.size(), Misc.getQuantifier(actors)));
        return 1;
    }

    private int saveState(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String name;
        Scene scene;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name = (String)ctx.getArgument("name", String.class)))) {
            return 0;
        }
        class_3222 target = class_2186.method_9315(ctx, (String)"player");
        scene.saveState((class_1657)target);
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43469((String)"theatrical.scene.state.saved", (Object[])new Object[]{target.method_5476()}));
        return 1;
    }

    private int loadState(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String name = (String)ctx.getArgument("name", String.class);
        boolean enabled = (Boolean)ctx.getArgument("enabled", Boolean.class);
        Scene scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name);
        if (this.checkScenePerms((class_1657)player, scene)) {
            return 0;
        }
        scene.setLoadStates(enabled);
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)(enabled ? "theatrical.scene.state.load_on" : "theatrical.scene.state.load_off")));
        return 1;
    }

    private int toggleVisuals(CommandContext<class_2168> ctx, boolean state) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String name = (String)ctx.getArgument("name", String.class);
        if (state) {
            ((VisualisedScenesComponent)TheatricalCardinalComponents.VISUALISED_SCENES.get((Object)player)).visualise(name);
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43469((String)"theatrical.scene.visuals.on", (Object[])new Object[]{name}));
        } else {
            ((VisualisedScenesComponent)TheatricalCardinalComponents.VISUALISED_SCENES.get((Object)player)).stopVisualisingScene(name);
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43469((String)"theatrical.scene.visuals.off", (Object[])new Object[]{name}));
        }
        return 1;
    }

    private int toggleTrust(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String name = (String)ctx.getArgument("name", String.class);
        class_1657 target = (class_1657)ctx.getArgument("player", class_1657.class);
        Scene scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(name);
        SceneCommand.feedback((class_1657)player, (class_2561)(scene.toggleTrust(target) ? class_2561.method_43469((String)"theatrical.scene.trust", (Object[])new Object[]{target.method_5476()}) : class_2561.method_43469((String)"theatrical.scene.untrust", (Object[])new Object[]{target.method_5476()})));
        return 1;
    }
}

