/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.mixin.impl;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.lilbrocodes.theatrical.cca.TheatricalCardinalComponents;
import org.lilbrocodes.theatrical.cca.entity.DirectorComponent;
import org.lilbrocodes.theatrical.cca.entity.HandHeldOutComponent;
import org.lilbrocodes.theatrical.cca.entity.LockedComponent;
import org.lilbrocodes.theatrical.cca.entity.PlotArmorComponent;
import org.lilbrocodes.theatrical.cca.entity.WalkSpeedComponent;
import org.lilbrocodes.theatrical.config.Configs;
import org.lilbrocodes.theatrical.mixin.accessor.DirectorDataHolder;
import org.lilbrocodes.theatrical.mixin.accessor.HandHeldDataHolder;
import org.lilbrocodes.theatrical.mixin.accessor.LockedDataHolder;
import org.lilbrocodes.theatrical.mixin.accessor.PlotArmorDataHolder;
import org.lilbrocodes.theatrical.mixin.accessor.WalkSpeedHolder;
import org.lilbrocodes.theatrical.util.PlotArmorType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements HandHeldDataHolder,
WalkSpeedHolder,
DirectorDataHolder,
PlotArmorDataHolder,
LockedDataHolder {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public boolean theatrical$isHandHeldOut() {
        return ((HandHeldOutComponent)TheatricalCardinalComponents.HAND_HELD_OUT.get((Object)this)).isHeld();
    }

    @Override
    public void theatrical$setHandHeldOut(boolean handHeld) {
        ((HandHeldOutComponent)TheatricalCardinalComponents.HAND_HELD_OUT.get((Object)this)).setHeld(handHeld);
    }

    @Override
    public int theatrical$getWalkSpeed() {
        return ((WalkSpeedComponent)TheatricalCardinalComponents.WALK_SPEED.get((Object)this)).getValue();
    }

    @Override
    public void theatrical$setWalkSpeed(int speed) {
        ((WalkSpeedComponent)TheatricalCardinalComponents.WALK_SPEED.get((Object)this)).setValue(speed);
    }

    @Override
    public boolean theatrical$isDirector() {
        return ((DirectorComponent)TheatricalCardinalComponents.DIRECTOR.get((Object)this)).isDirector();
    }

    @Override
    public void theatrical$setDirector(boolean director) {
        ((DirectorComponent)TheatricalCardinalComponents.DIRECTOR.get((Object)this)).setDirector(director);
    }

    @Override
    public PlotArmorType theatrical$getType() {
        return ((PlotArmorComponent)TheatricalCardinalComponents.PLOT_ARMOR_TYPE.get((Object)this)).getType();
    }

    @Override
    public void theatrical$setType(PlotArmorType type) {
        ((PlotArmorComponent)TheatricalCardinalComponents.PLOT_ARMOR_TYPE.get((Object)this)).setType(type);
    }

    @Override
    public boolean theatrical$isLocked() {
        return ((LockedComponent)TheatricalCardinalComponents.LOCKED.get((Object)this)).isLocked();
    }

    @Override
    public void theatrical$setLocked(boolean locked) {
        ((LockedComponent)TheatricalCardinalComponents.LOCKED.get((Object)this)).setLocked(locked);
    }

    @ModifyReturnValue(method={"getMovementSpeed"}, at={@At(value="TAIL")})
    public float theatrical$applyMovementSpeed(float original) {
        return original * ((float)this.theatrical$getWalkSpeed() / 100.0f) * (this.theatrical$isLocked() ? 0.0f : 1.0f);
    }

    @Inject(method={"applyDamage"}, at={@At(value="TAIL")})
    private void theatrical$plotArmorAdjustments(class_1282 source, float amount, CallbackInfo ci) {
        PlayerEntityMixin playerEntityMixin = this;
        if (playerEntityMixin instanceof class_1657) {
            float multiplier;
            class_1657 player = (class_1657)playerEntityMixin;
            PlotArmorType type = ((PlotArmorDataHolder)player).theatrical$getType();
            if (type == PlotArmorType.POSITIVE) {
                float minHealth = Configs.SERVER.plotArmor.positive_minHealth * 2.0f;
                if (player.method_6032() < minHealth) {
                    player.method_6033(minHealth);
                }
            } else if (type == PlotArmorType.NEGATIVE && (multiplier = Configs.SERVER.plotArmor.negative_damageMultiplier) > 1.0f) {
                float extra = amount * (multiplier - 1.0f);
                player.method_6033(Math.max(player.method_6032() - extra, 0.0f));
            }
        }
    }
}

