/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.lilbrocodes.theatrical.cca.TheatricalCardinalComponents;
import org.lilbrocodes.theatrical.cca.world.CountdownInstanceHolderComponent;
import org.lilbrocodes.theatrical.commands.CommandUtil;
import org.lilbrocodes.theatrical.config.Configs;

public class CountdownAttempt {
    private static final Map<Integer, Map<Integer, class_2561>> STATE_TEXTS = Map.of(0, Map.of(0, class_2561.method_43471((String)"theatrical.countdown.state.in_cooldown").method_27692(class_124.field_1061).method_27692(class_124.field_1067), 1, class_2561.method_43471((String)"theatrical.countdown.state.not_in_cooldown").method_27692(class_124.field_1060).method_27692(class_124.field_1067)), 1, Map.of(0, class_2561.method_43471((String)"theatrical.countdown.state.vc.not_loaded").method_27692(class_124.field_1065).method_27692(class_124.field_1067), 1, class_2561.method_43471((String)"theatrical.countdown.state.vc.recording").method_27692(class_124.field_1060).method_27692(class_124.field_1067), 2, class_2561.method_43471((String)"theatrical.countdown.state.vc.started").method_27692(class_124.field_1054).method_27692(class_124.field_1067), 3, class_2561.method_43471((String)"theatrical.countdown.state.vc.stopped").method_27692(class_124.field_1061).method_27692(class_124.field_1067), 4, class_2561.method_43471((String)"theatrical.countdown.state.vc.disabled").method_27692(class_124.field_1065).method_27692(class_124.field_1067)), 2, Map.of(0, class_2561.method_43471((String)"theatrical.countdown.state.rm.not_loaded").method_27692(class_124.field_1065).method_27692(class_124.field_1067), 1, class_2561.method_43471((String)"theatrical.countdown.state.rm.recording").method_27692(class_124.field_1060).method_27692(class_124.field_1067), 2, class_2561.method_43471((String)"theatrical.countdown.state.rm.started").method_27692(class_124.field_1054).method_27692(class_124.field_1067), 3, class_2561.method_43471((String)"theatrical.countdown.state.rm.stopped").method_27692(class_124.field_1061).method_27692(class_124.field_1067), 4, class_2561.method_43471((String)"theatrical.countdown.state.rm.disabled").method_27692(class_124.field_1065).method_27692(class_124.field_1067)));
    public final UUID owner;
    public final Map<UUID, List<Integer>> players;
    public final int duration;
    public final long creationTime;

    public CountdownAttempt(UUID owner, Map<UUID, List<Integer>> players, int duration, @Nullable Long startTime) {
        this.owner = owner;
        this.players = players;
        this.duration = duration;
        this.creationTime = startTime == null ? System.currentTimeMillis() : startTime;
    }

    public CountdownAttempt(UUID owner, List<UUID> players, int duration, @Nullable Long startTime) {
        this.owner = owner;
        this.players = new HashMap<UUID, List<Integer>>();
        players.forEach(uuid -> this.players.put((UUID)uuid, new ArrayList()));
        this.duration = duration;
        this.creationTime = startTime == null ? System.currentTimeMillis() : startTime;
    }

    public void setState(UUID player, List<Integer> state) {
        if (this.players.containsKey(player)) {
            this.players.put(player, state);
        }
    }

    public boolean getStartable() {
        int failCount = 0;
        for (List<Integer> value : this.players.values()) {
            if (this.isSuccess(value)) continue;
            ++failCount;
        }
        return failCount <= (Integer)Configs.SERVER.tolerableUncheckedPlayers.get();
    }

    private boolean isSuccess(List<Integer> state) {
        if (state.isEmpty()) {
            return false;
        }
        int inCountdownState = state.get(0);
        int voicechatState = state.get(1);
        int replaymodState = state.get(2);
        boolean inCountdownValid = inCountdownState == 1;
        boolean replaymodValid = replaymodState != 3;
        boolean voicechatValid = voicechatState != 3;
        return inCountdownValid && replaymodValid && voicechatValid;
    }

    public boolean notifyOwnerIfNotAllSuccess(class_1937 world) {
        boolean allResponded = this.players.values().stream().noneMatch(List::isEmpty);
        if (!allResponded) {
            return false;
        }
        boolean allSuccess = this.getStartable();
        if (allSuccess) {
            return false;
        }
        class_1657 ownerPlayer = world.method_18470(this.owner);
        if (!(ownerPlayer instanceof class_3222)) {
            return false;
        }
        List playerStates = this.players.entrySet().stream().map(entry -> {
            UUID playerUuid = (UUID)entry.getKey();
            List state = (List)entry.getValue();
            if (this.isSuccess(state)) {
                return class_2561.method_43470((String)"");
            }
            String playerName = Optional.ofNullable(world.method_18470(playerUuid)).map(p -> p.method_5477().getString()).orElse(playerUuid.toString());
            class_5250 text = class_2561.method_43470((String)("\u2022 " + playerName)).method_27692(class_124.field_1065);
            for (int i = 0; i < state.size(); ++i) {
                int value = (Integer)state.get(i);
                class_2561 stateText = (class_2561)STATE_TEXTS.getOrDefault(i, Collections.emptyMap()).getOrDefault(value, class_2561.method_43471((String)"theatrical.countdown.state.unknown"));
                text.method_10852((class_2561)class_2561.method_43470((String)"\n   ")).method_10852(stateText);
            }
            return text;
        }).collect(Collectors.toList());
        class_5250 message = class_2561.method_43471((String)"command.theatrical.countdown.fail2").method_27692(class_124.field_1067);
        for (class_2561 playerText : playerStates) {
            message.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852(playerText);
        }
        CommandUtil.feedback(ownerPlayer, (class_2561)message);
        return true;
    }

    public class_2487 writeToNbt(class_2487 tag) {
        class_2499 playerList = new class_2499();
        for (Map.Entry<UUID, List<Integer>> entry : this.players.entrySet()) {
            UUID uuid = entry.getKey();
            List<Integer> stateList = entry.getValue();
            class_2487 playerTag = new class_2487();
            playerTag.method_10566("uuid", (class_2520)new class_2501(new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()}));
            class_2499 stateNbtList = new class_2499();
            for (Integer state : stateList) {
                stateNbtList.add((Object)class_2497.method_23247((int)state));
            }
            playerTag.method_10566("state", (class_2520)stateNbtList);
            playerList.add((Object)playerTag);
        }
        tag.method_10566("players", (class_2520)playerList);
        tag.method_10569("duration", this.duration);
        tag.method_25927("owner", this.owner);
        tag.method_10544("creationTime", this.creationTime);
        return tag;
    }

    public static CountdownAttempt readFromNbt(class_2487 tag) {
        HashMap<UUID, List<Integer>> players = new HashMap<UUID, List<Integer>>();
        class_2499 playerList = tag.method_10554("players", 10);
        for (class_2520 element : playerList) {
            class_2487 playerTag;
            long[] uuidLongs;
            if (!(element instanceof class_2487) || (uuidLongs = (playerTag = (class_2487)element).method_10565("uuid")).length != 2) continue;
            UUID uuid = new UUID(uuidLongs[0], uuidLongs[1]);
            ArrayList<Integer> stateList = new ArrayList<Integer>();
            class_2499 stateNbtList = playerTag.method_10554("state", 3);
            for (class_2520 stateElement : stateNbtList) {
                stateList.add(((class_2497)stateElement).method_10701());
            }
            players.put(uuid, stateList);
        }
        int duration = tag.method_10550("duration");
        long creationTime = tag.method_10537("creationTime");
        UUID ownerUuid = tag.method_25926("owner");
        return new CountdownAttempt(ownerUuid, players, duration, (Long)creationTime);
    }

    public boolean shouldRemove(class_1937 world) {
        if (System.currentTimeMillis() - this.creationTime >= (long)((Integer)Configs.SERVER.countdownTimeoutMinutes.get() * 60000)) {
            class_1657 player = world.method_18470(this.owner);
            if (player != null) {
                CommandUtil.feedback(player, (class_2561)class_2561.method_43471((String)"command.theatrical.countdown.fail1"));
            }
            return true;
        }
        if (this.notifyOwnerIfNotAllSuccess(world)) {
            return true;
        }
        if (this.getStartable()) {
            ((CountdownInstanceHolderComponent)TheatricalCardinalComponents.COUNTDOWNS.get((Object)world)).create(new ArrayList<UUID>(this.players.keySet()), this.duration);
            return true;
        }
        return false;
    }
}

