/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2520;

public class CountdownInstance {
    public final List<UUID> players;
    public final int duration;
    public int progress;

    public CountdownInstance(List<UUID> players, int progress, int duration) {
        this.players = players;
        this.progress = progress;
        this.duration = duration;
    }

    public CountdownInstance(List<UUID> players, int duration) {
        this(players, 0, duration);
    }

    public class_2487 writeToNbt(class_2487 tag) {
        class_2499 playerList = new class_2499();
        for (UUID uuid : this.players) {
            playerList.add((Object)new class_2501(new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()}));
        }
        tag.method_10566("players", (class_2520)playerList);
        tag.method_10569("progress", this.progress);
        tag.method_10569("duration", this.duration);
        return tag;
    }

    public static CountdownInstance readFromNbt(class_2487 tag) {
        ArrayList<UUID> players = new ArrayList<UUID>();
        class_2499 playerList = tag.method_10554("players", 12);
        for (class_2520 nbtElement : playerList) {
            class_2501 uuidArray = (class_2501)nbtElement;
            long[] uuidLongs = uuidArray.method_10615();
            if (uuidLongs.length != 2) continue;
            UUID uuid = new UUID(uuidLongs[0], uuidLongs[1]);
            players.add(uuid);
        }
        int progress = tag.method_10550("progress");
        int duration = tag.method_10550("duration");
        return new CountdownInstance(players, progress, duration);
    }

    public boolean tick() {
        return this.progress++ >= this.duration;
    }
}

