/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.cca.world;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.lilbrocodes.theatrical.cca.TheatricalCardinalComponents;
import org.lilbrocodes.theatrical.scene.Scene;

public class SceneHolderComponent
implements AutoSyncedComponent {
    public Map<String, Scene> scenes;
    public final class_1937 world;

    public SceneHolderComponent(class_1937 world) {
        this.world = world;
        this.scenes = new HashMap<String, Scene>();
    }

    public void sync() {
        TheatricalCardinalComponents.SCENES.sync((Object)this.world);
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        this.scenes.clear();
        class_2499 sceneTag = tag.method_10554("scenes", 10);
        sceneTag.forEach(nbtElement -> {
            if (nbtElement instanceof class_2487) {
                class_2487 nbt = (class_2487)nbtElement;
                String name = nbt.method_10558("name");
                Scene scene = Scene.readFromNbt(this.world, nbt.method_10562("scene"));
                this.scenes.put(name, scene);
            }
        });
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        class_2499 sceneTag = new class_2499();
        this.scenes.forEach((name, scene) -> {
            class_2487 nbt = new class_2487();
            nbt.method_10582("name", name);
            nbt.method_10566("scene", (class_2520)scene.writeToNbt(new class_2487()));
            sceneTag.add((Object)nbt);
        });
        tag.method_10566("scenes", (class_2520)sceneTag);
    }

    public void tryStart(List<UUID> players) {
        this.scenes.values().forEach(scene -> {
            if (scene.actors().size() == players.size() && new HashSet(players).containsAll(scene.actors())) {
                scene.start();
            }
        });
        this.sync();
    }
}

