/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.scene;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import org.lilbrocodes.theatrical.mixin.accessor.LockedDataHolder;

public class Scene {
    private final UUID director;
    private final class_1937 world;
    public final Map<UUID, ActorData> actors;
    private final Map<UUID, ActorState> states = new HashMap<UUID, ActorState>();
    private final List<UUID> trusted;
    private boolean lock;
    private boolean loadStates;
    private boolean setup;

    public Scene(class_1937 world, UUID director, Map<UUID, ActorData> actors, List<UUID> trusted, boolean lock, boolean loadStates, boolean setup) {
        this.director = director;
        this.world = world;
        this.actors = actors;
        this.trusted = trusted;
        this.lock = lock;
        this.loadStates = loadStates;
        this.setup = setup;
    }

    public Scene(class_1937 world, UUID director, boolean lock, boolean loadStates) {
        this(world, director, new HashMap<UUID, ActorData>(), new ArrayList<UUID>(), lock, loadStates, false);
    }

    public boolean add(UUID id, class_243 pos, float yaw, float pitch) {
        if (this.actors.containsKey(id)) {
            return false;
        }
        this.actors.put(id, new ActorData(pos, yaw, pitch));
        return true;
    }

    public boolean add(class_1657 player) {
        return this.add(player.method_5667(), player.method_19538(), player.method_36454(), player.method_36455());
    }

    public void move(UUID id, class_243 pos, float yaw, float pitch) {
        this.actors.put(id, new ActorData(pos, yaw, pitch));
    }

    public void remove(UUID id) {
        this.actors.remove(id);
    }

    public boolean hasPermission(UUID id) {
        return this.director.equals(id) || this.trusted.contains(id);
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public void setLoadStates(boolean enabled) {
        this.loadStates = enabled;
    }

    public List<UUID> actors() {
        return this.actors.keySet().stream().toList();
    }

    public boolean toggleTrust(class_1657 player) {
        UUID id = player.method_5667();
        if (this.trusted.contains(id)) {
            this.trusted.remove(id);
            return false;
        }
        this.trusted.add(id);
        return true;
    }

    public void saveState(class_1657 player) {
        class_2487 tag = new class_2487();
        player.method_5647(tag);
        this.states.put(player.method_5667(), new ActorState(tag));
    }

    public void restoreState(class_1657 player) {
        ActorState state = this.states.get(player.method_5667());
        if (state != null) {
            player.method_5651(state.data().method_10553());
        }
    }

    public ActorState getState(UUID actorId) {
        return this.states.get(actorId);
    }

    public void setup() {
        this.world.method_18456().forEach(player -> {
            ActorData data = this.actors.get(player.method_5667());
            if (data != null && player instanceof LockedDataHolder) {
                LockedDataHolder holder = (LockedDataHolder)player;
                player.method_48105((class_3218)this.world, data.pos.field_1352, data.pos.field_1351, data.pos.field_1350, EnumSet.noneOf(class_2709.class), data.yaw, data.pitch);
                if (this.loadStates) {
                    this.restoreState((class_1657)player);
                }
                holder.theatrical$setLocked(this.lock);
            }
        });
        this.setup = true;
    }

    public void start() {
        if (this.setup) {
            this.setup = false;
            this.world.method_18456().forEach(player -> {
                if (this.actors.containsKey(player.method_5667()) && player instanceof LockedDataHolder) {
                    LockedDataHolder holder = (LockedDataHolder)player;
                    holder.theatrical$setLocked(false);
                }
            });
        }
    }

    public class_2487 writeToNbt(class_2487 tag) {
        tag.method_25927("director", this.director);
        tag.method_10556("lock", this.lock);
        tag.method_10556("setup", this.setup);
        class_2499 actorTag = new class_2499();
        this.actors.forEach((id, data) -> {
            class_2487 t = new class_2487();
            t.method_25927("id", id);
            t.method_10549("x", data.pos().field_1352);
            t.method_10549("y", data.pos().field_1351);
            t.method_10549("z", data.pos().field_1350);
            t.method_10548("yaw", data.yaw());
            t.method_10548("pitch", data.pitch());
            actorTag.add((Object)t);
        });
        tag.method_10566("actors", (class_2520)actorTag);
        class_2499 trustedTag = new class_2499();
        this.trusted.forEach(id -> {
            class_2487 c = new class_2487();
            c.method_25927("id", id);
            trustedTag.add((Object)c);
        });
        tag.method_10566("trusted", (class_2520)trustedTag);
        class_2499 stateTag = new class_2499();
        this.states.forEach((id, state) -> {
            class_2487 t = new class_2487();
            t.method_25927("id", id);
            t.method_10566("data", (class_2520)state.data());
            stateTag.add((Object)t);
        });
        tag.method_10566("states", (class_2520)stateTag);
        tag.method_10556("loadStates", this.loadStates);
        return tag;
    }

    public static Scene readFromNbt(class_1937 world, class_2487 tag) {
        UUID director = tag.method_25926("director");
        boolean lock = tag.method_10577("lock");
        boolean setup = tag.method_10577("setup");
        class_2499 actorTag = tag.method_10554("actors", 10);
        HashMap<UUID, ActorData> actors = new HashMap<UUID, ActorData>();
        actorTag.forEach(t -> {
            if (t instanceof class_2487) {
                class_2487 nbt = (class_2487)t;
                UUID id = nbt.method_25926("id");
                class_243 pos = new class_243(nbt.method_10574("x"), nbt.method_10574("y"), nbt.method_10574("z"));
                float yaw = nbt.method_10583("yaw");
                float pitch = nbt.method_10583("pitch");
                actors.put(id, new ActorData(pos, yaw, pitch));
            }
        });
        class_2499 trustedTag = tag.method_10554("trusted", 10);
        ArrayList<UUID> trusted = new ArrayList<UUID>();
        trustedTag.forEach(t -> {
            if (t instanceof class_2487) {
                class_2487 nbt = (class_2487)t;
                trusted.add(nbt.method_25926("id"));
            }
        });
        class_2499 stateTag = tag.method_10554("states", 10);
        HashMap states = new HashMap();
        stateTag.forEach(t -> {
            if (t instanceof class_2487) {
                class_2487 nbt = (class_2487)t;
                states.put(nbt.method_25926("id"), new ActorState(nbt.method_10562("data")));
            }
        });
        boolean loadStates = tag.method_10577("loadStates");
        Scene scene = new Scene(world, director, actors, trusted, lock, loadStates, setup);
        scene.states.putAll(states);
        return scene;
    }

    public record ActorData(class_243 pos, float yaw, float pitch) {
    }

    public record ActorState(class_2487 data) {
    }
}

