/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.commands.argument_type;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_637;
import org.lilbrocodes.theatrical.util.Misc;

public class PlayerListArgumentType
implements ArgumentType<List<String>> {
    private final boolean allowDuplicates;

    PlayerListArgumentType(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean allowsDuplicates() {
        return this.allowDuplicates;
    }

    public static PlayerListArgumentType duplicates() {
        return new PlayerListArgumentType(true);
    }

    public static PlayerListArgumentType noDuplicates() {
        return new PlayerListArgumentType(false);
    }

    public List<String> parse(StringReader reader) throws CommandSyntaxException {
        ArrayList<String> players = new ArrayList<String>();
        while (reader.canRead()) {
            reader.skipWhitespace();
            int start = reader.getCursor();
            while (reader.canRead() && !Character.isWhitespace(reader.peek())) {
                reader.skip();
            }
            String name = reader.getString().substring(start, reader.getCursor());
            if (name.isEmpty()) continue;
            if (players.contains(name) && !this.allowDuplicates) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)("Duplicate player: " + name));
            }
            players.add(name);
        }
        return players;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        String[] parts = remaining.split(" ");
        String lastPart = parts.length == 0 ? "" : parts[parts.length - 1];
        HashSet<String> alreadyTyped = new HashSet<String>();
        for (int i = 0; i < parts.length - 1; ++i) {
            if (parts[i].isEmpty()) continue;
            alreadyTyped.add(parts[i]);
        }
        Collection allNames = new ArrayList();
        Object object = context.getSource();
        if (object instanceof class_2168) {
            class_2168 source = (class_2168)object;
            allNames = source.method_9262();
        } else {
            object = context.getSource();
            if (object instanceof class_637) {
                class_637 source = (class_637)object;
                allNames = source.method_9262();
            }
        }
        for (String name : allNames) {
            if (alreadyTyped.contains(name) || !name.startsWith(lastPart)) continue;
            builder.suggest(Misc.joinAndAppend(parts, name));
        }
        return builder.buildFuture();
    }
}

