/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.config;

import me.fzzyhmstrs.fzzy_config.api.FileType;
import me.fzzyhmstrs.fzzy_config.api.SaveType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigSection;
import me.fzzyhmstrs.fzzy_config.util.Translatable;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import org.jetbrains.annotations.NotNull;
import org.lilbrocodes.theatrical.Theatrical;
import org.lilbrocodes.theatrical.util.BindsMode;

public class TheatricalClientConfig
extends Config {
    public static final int CONFIG_VERSION = 2;
    @Translatable.Prefix(value="Used for keeping track of what config version you have, and running some data fixes if needed. Changing it will currently reset your client config to default.")
    public int configVersion = 2;
    public VisualsSection visuals = new VisualsSection();
    public ControlsSection controls = new ControlsSection();
    public ChecksSection checks = new ChecksSection();

    public TheatricalClientConfig() {
        super(Theatrical.identify("client_config"));
    }

    public int defaultPermLevel() {
        return 0;
    }

    @NotNull
    public FileType fileType() {
        return FileType.JSONC;
    }

    @NotNull
    public SaveType saveType() {
        return SaveType.SEPARATE;
    }

    @NotNull
    public String translationKey() {
        return "theatrical.client_config";
    }

    public boolean hasTranslation() {
        return true;
    }

    public static class VisualsSection
    extends ConfigSection {
        @Translatable.Name(value="Rainbow Effect on Duplicate Keybinds")
        public boolean rainbowDuplicateKeybinds = false;
        @Translatable.Name(value="Rainbow Effect Speed")
        public ValidatedInt rainbowEffectSpeed = new ValidatedInt(3, 10, 1);
        @Translatable.Name(value="Show Walk Speed Change Message")
        public boolean showWalkSpeedChangeMessage = true;
    }

    public static class ControlsSection
    extends ConfigSection {
        @Translatable.Name(value="Allow Duplicate Keybinds")
        public BindsMode allowDuplicateKeybinds = BindsMode.MC_AND_TH;
    }

    public static class ChecksSection
    extends ConfigSection {
        public VoicechatSection voicechat = new VoicechatSection();
        public ReplaymodSection replaymod = new ReplaymodSection();

        public static class VoicechatSection
        extends ConfigSection {
            @Translatable.Prefix(value="If enabled, upon starting a countdown - instead of reporting that audio is not being recorded, it starts recording automatically")
            public boolean autoStartRecording = false;
            @Translatable.Prefix(value="If enabled, it will require that you are recording voicechat audio if a countdown gets started with you in it")
            public boolean checkForRecording = false;
        }

        public static class ReplaymodSection
        extends ConfigSection {
            @Translatable.Prefix(value="If enabled, upon starting a countdown - instead of reporting that a replay is not being recorded, it starts recording automatically")
            public boolean autoStartRecording = false;
            @Translatable.Prefix(value="If enabled, it will require that you are recording a replay if a countdown gets started with you in it")
            public boolean checkForRecording = false;
        }
    }
}

