/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.config;

import me.fzzyhmstrs.fzzy_config.api.FileType;
import me.fzzyhmstrs.fzzy_config.api.SaveType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigSection;
import me.fzzyhmstrs.fzzy_config.util.Translatable;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import org.jetbrains.annotations.NotNull;
import org.lilbrocodes.theatrical.Theatrical;

public class TheatricalServerConfig
extends Config {
    public PlotArmorSection plotArmor = new PlotArmorSection();
    @Translatable.Prefix(value="The amount of players that can have their checks not pass when starting a countdown for that countdown to start successfully")
    public ValidatedInt tolerableUncheckedPlayers = new ValidatedInt(0, Integer.MAX_VALUE, 0);
    @Translatable.Prefix(value="The amount of time to wait before giving up on trying to start a countdown")
    public ValidatedInt countdownTimeoutMinutes = new ValidatedInt(5, Integer.MAX_VALUE, 0);

    public TheatricalServerConfig() {
        super(Theatrical.identify("server_config"));
    }

    public int defaultPermLevel() {
        return 4;
    }

    @NotNull
    public FileType fileType() {
        return FileType.JSONC;
    }

    @NotNull
    public SaveType saveType() {
        return SaveType.SEPARATE;
    }

    @NotNull
    public String translationKey() {
        return "theatrical.server_config";
    }

    public boolean hasTranslation() {
        return true;
    }

    public static class PlotArmorSection
    extends ConfigSection {
        @Translatable.Name(value="Positive - Minimum Health")
        public float positive_minHealth = 0.5f;
        @Translatable.Name(value="Positive - Regen Speed")
        public float positive_regenAmount = 2.0f;
        @Translatable.Name(value="Negative - Damage Multiplier")
        public float negative_damageMultiplier = 1.3f;
        @Translatable.Name(value="Negative - Regen Multiplier")
        public float negative_regenMultiplier = 0.5f;
    }
}

