/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.util;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.lilbrocodes.composer_reloaded.api.render.ToastDrawUtils;
import org.lilbrocodes.theatrical.mixin.accessor.DirectorDataHolder;

public class Misc {
    private static final SimpleCommandExceptionType NOT_DIRECTOR_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"exception.theatrical.not_director"));

    public static String getQuantifier(List<?> list) {
        if (list.size() == 1) {
            return "";
        }
        return "s";
    }

    public static String joinAndAppend(String[] list, String append) {
        if (list == null || list.length == 0) {
            return append;
        }
        return Arrays.stream(list, 0, list.length - 1).collect(Collectors.joining(" ")) + (list.length > 1 ? " " : "") + append;
    }

    public static void checkDirectorOrThrow(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        if (!Misc.isDirector((class_2168)ctx.getSource())) {
            throw NOT_DIRECTOR_EXCEPTION.create();
        }
    }

    public static boolean isDirector(class_2168 src) {
        DirectorDataHolder holder;
        class_3222 class_32222;
        if (src.method_9259(4)) {
            return true;
        }
        return src.method_43737() && (class_32222 = src.method_44023()) instanceof DirectorDataHolder && (holder = (DirectorDataHolder)class_32222).theatrical$isDirector();
    }

    public static int mixSpeedColor(int speed) {
        int r = (int)((double)(255 * (100 - speed)) / 100.0);
        return r << 16 | 0xFF00;
    }

    public static int mixProgressColor(int duration, int progress) {
        int g;
        int r;
        if (duration <= 0) {
            return ToastDrawUtils.argb((int)255, (int)255, (int)0, (int)0);
        }
        float t = (float)(progress = Math.max(0, Math.min(progress, duration))) / (float)duration;
        if (t < 0.5f) {
            localT = t / 0.5f;
            r = 255;
            g = (int)(localT * 255.0f);
        } else {
            localT = (t - 0.5f) / 0.5f;
            r = (int)(255.0f * (1.0f - localT));
            g = 255;
        }
        int b = 0;
        int a = 255;
        return ToastDrawUtils.argb((int)r, (int)g, (int)b, (int)a);
    }

    public static int mixProgressDarkColor(int duration, int progress) {
        int brightG;
        int brightR;
        if (duration <= 0) {
            return ToastDrawUtils.argb((int)80, (int)70, (int)0, (int)61);
        }
        float t = (float)(progress = Math.max(0, Math.min(progress, duration))) / (float)duration;
        if (t < 0.5f) {
            localT = t / 0.5f;
            brightR = 255;
            brightG = (int)(localT * 255.0f);
        } else {
            localT = (t - 0.5f) / 0.5f;
            brightR = (int)(255.0f * (1.0f - localT));
            brightG = 255;
        }
        boolean brightB = false;
        int baseR = 70;
        boolean baseG = false;
        int baseB = 61;
        float blendFactor = 0.3f;
        int r = (int)((float)brightR * blendFactor + (float)baseR * (1.0f - blendFactor));
        int g = (int)((float)brightG * blendFactor + (float)baseG * (1.0f - blendFactor));
        int b = (int)((float)brightB * blendFactor + (float)baseB * (1.0f - blendFactor));
        int a = 80;
        return ToastDrawUtils.argb((int)r, (int)g, (int)b, (int)a);
    }
}

