/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.lilbrocodes.theatrical.cca.TheatricalCardinalComponents;
import org.lilbrocodes.theatrical.cca.entity.VisualisedScenesComponent;
import org.lilbrocodes.theatrical.cca.world.CountdownAttemptHolderComponent;
import org.lilbrocodes.theatrical.cca.world.SceneHolderComponent;
import org.lilbrocodes.theatrical.commands.CommandUtil;
import org.lilbrocodes.theatrical.scene.Scene;
import org.lilbrocodes.theatrical.util.Misc;
import org.lilbrocodes.theatrical.util.TextUtil;

public class SceneCommand
extends CommandUtil {
    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"scene").then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"lock", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"loadStates", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            Scene scene = new Scene(player.method_37908(), player.method_5667(), (Boolean)ctx.getArgument("lock", Boolean.class), (Boolean)ctx.getArgument("loadStates", Boolean.class));
            ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.put((String)ctx.getArgument("name", String.class), scene);
            ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).sync();
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.created"));
            return 1;
        })))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).executes(ctx -> {
            Scene scene;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(ctx.getArgument("name", String.class)))) {
                return 0;
            }
            ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.remove(ctx.getArgument("name", String.class));
            ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).sync();
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43469((String)"theatrical.scene.removed", (Object[])new Object[]{ctx.getArgument("name", String.class)}).method_27692(class_124.field_1060));
            return 1;
        })))).then(class_2170.method_9247((String)"edit").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9247((String)"lock").then(class_2170.method_9244((String)"lock", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Scene scene;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(ctx.getArgument("name", String.class)))) {
                return 0;
            }
            scene.setLock((Boolean)ctx.getArgument("lock", Boolean.class));
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.edit.success"));
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"pos").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"player");
            return this.add((class_2168)ctx.getSource(), (String)ctx.getArgument("name", String.class), target.method_5667(), target.method_19538(), new class_241(target.method_36454(), target.method_36455()));
        })))).then(class_2170.method_9247((String)"coords").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(ctx -> {
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"player");
            class_243 pos = class_2277.method_9736((CommandContext)ctx, (String)"pos");
            return this.add((class_2168)ctx.getSource(), (String)ctx.getArgument("name", String.class), target.method_5667(), pos, null);
        })).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(ctx -> {
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"player");
            class_243 pos = class_2277.method_9736((CommandContext)ctx, (String)"pos");
            class_241 rot = class_2270.method_9716((CommandContext)ctx, (String)"rotation").method_9709((class_2168)ctx.getSource());
            return this.add((class_2168)ctx.getSource(), (String)ctx.getArgument("name", String.class), target.method_5667(), pos, rot);
        }))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"move").then(class_2170.method_9247((String)"pos").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"player");
            return this.move((class_2168)ctx.getSource(), (String)ctx.getArgument("name", String.class), target.method_5667(), target.method_19538(), new class_241(target.method_36454(), target.method_36455()));
        })))).then(class_2170.method_9247((String)"coords").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(ctx -> {
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"player");
            class_243 pos = class_2277.method_9736((CommandContext)ctx, (String)"pos");
            return this.move((class_2168)ctx.getSource(), (String)ctx.getArgument("name", String.class), target.method_5667(), pos, null);
        })).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(ctx -> {
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"player");
            class_243 pos = class_2277.method_9736((CommandContext)ctx, (String)"pos");
            class_241 rot = class_2270.method_9716((CommandContext)ctx, (String)"rotation").method_9709((class_2168)ctx.getSource());
            return this.move((class_2168)ctx.getSource(), (String)ctx.getArgument("name", String.class), target.method_5667(), pos, rot);
        }))))))))).then(class_2170.method_9247((String)"setup").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).executes(ctx -> {
            Scene scene;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(ctx.getArgument("name", String.class)))) {
                return 0;
            }
            scene.setup();
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.setup"));
            return 1;
        })))).then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).executes(ctx -> {
            Scene scene;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(ctx.getArgument("name", String.class)))) {
                return 0;
            }
            scene.start();
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.start"));
            return 1;
        })))).then(class_2170.method_9247((String)"countdown").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3600)).executes(ctx -> {
            Scene scene;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(ctx.getArgument("name", String.class)))) {
                return 0;
            }
            int duration = (Integer)ctx.getArgument("duration", Integer.class) * 20;
            List<UUID> actors = scene.actors();
            ((CountdownAttemptHolderComponent)TheatricalCardinalComponents.COUNTDOWN_ATTEMPTS.get((Object)player.method_37908())).create(player.method_5667(), actors, duration);
            SceneCommand.feedback((CommandContext<class_2168>)ctx, TextUtil.replaceTranslatable("command.theatrical.countdown.success", duration, actors.size(), Misc.getQuantifier(actors)));
            return 1;
        }))))).then(class_2170.method_9247((String)"state").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9247((String)"save").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            Scene scene;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(ctx.getArgument("name", String.class)))) {
                return 0;
            }
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"player");
            scene.saveState((class_1657)target);
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43469((String)"theatrical.scene.state.saved", (Object[])new Object[]{target.method_5476()}));
            return 1;
        })))).then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Scene scene;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(ctx.getArgument("name", String.class)))) {
                return 0;
            }
            boolean enabled = (Boolean)ctx.getArgument("enabled", Boolean.class);
            scene.setLoadStates(enabled);
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)(enabled ? "theatrical.scene.state.load_on" : "theatrical.scene.state.load_off")));
            return 1;
        })))))).then(class_2170.method_9247((String)"visuals").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9247((String)"on").executes(ctx -> this.toggleVisuals((CommandContext<class_2168>)ctx, true)))).then(class_2170.method_9247((String)"off").executes(ctx -> this.toggleVisuals((CommandContext<class_2168>)ctx, false)))))).then(class_2170.method_9247((String)"trust").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this::scenes).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_1657 target;
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            Scene scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(ctx.getArgument("name", String.class));
            SceneCommand.feedback((class_1657)player, (class_2561)(scene.toggleTrust(target = (class_1657)ctx.getArgument("player", class_1657.class)) ? class_2561.method_43469((String)"theatrical.scene.trust", (Object[])new Object[]{target.method_5476()}) : class_2561.method_43469((String)"theatrical.scene.untrust", (Object[])new Object[]{target.method_5476()})));
            return 1;
        }))))).requires(Misc::isDirector));
    }

    private CompletableFuture<Suggestions> scenes(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }

    private boolean checkScenePerms(class_1657 player, Scene scene) {
        if (scene == null) {
            SceneCommand.feedback(player, (class_2561)class_2561.method_43471((String)"theatrical.scene.edit.not_exists").method_27692(class_124.field_1061));
            return true;
        }
        if (!scene.hasPermission(player.method_5667())) {
            SceneCommand.feedback(player, (class_2561)class_2561.method_43471((String)"theatrical.scene.edit.no_permission").method_27692(class_124.field_1061));
            return true;
        }
        return false;
    }

    private int add(class_2168 source, String sceneName, UUID actor, class_243 pos, class_241 rotation) throws CommandSyntaxException {
        Scene scene;
        class_3222 player = source.method_9207();
        if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(sceneName))) {
            return 0;
        }
        if (!scene.add(actor, pos, rotation.field_1343, rotation.field_1342)) {
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.add.already_exists"));
            return 0;
        }
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.add.success"));
        return 1;
    }

    private int move(class_2168 source, String sceneName, UUID actor, class_243 pos, class_241 rotation) throws CommandSyntaxException {
        Scene scene;
        class_3222 player = source.method_9207();
        if (this.checkScenePerms((class_1657)player, scene = ((SceneHolderComponent)TheatricalCardinalComponents.SCENES.get((Object)player.method_37908())).scenes.get(sceneName))) {
            return 0;
        }
        if (rotation != null) {
            scene.move(actor, pos, rotation.field_1343, rotation.field_1342);
        } else {
            scene.move(actor, pos, 0.0f, 0.0f);
        }
        SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43471((String)"theatrical.scene.move.success"));
        return 1;
    }

    private int toggleVisuals(CommandContext<class_2168> ctx, boolean state) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String scene = (String)ctx.getArgument("name", String.class);
        if (state) {
            ((VisualisedScenesComponent)TheatricalCardinalComponents.VISUALISED_SCENES.get((Object)player)).visualise(scene);
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43469((String)"theatrical.scene.visuals.on", (Object[])new Object[]{scene}));
        } else {
            ((VisualisedScenesComponent)TheatricalCardinalComponents.VISUALISED_SCENES.get((Object)player)).stopVisualisingScene(scene);
            SceneCommand.feedback((class_1657)player, (class_2561)class_2561.method_43469((String)"theatrical.scene.visuals.off", (Object[])new Object[]{scene}));
        }
        return 1;
    }
}

