/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical;

import java.util.ArrayList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.lilbrocodes.theatrical.cca.TheatricalCardinalComponents;
import org.lilbrocodes.theatrical.cca.world.CountdownAttemptHolderComponent;
import org.lilbrocodes.theatrical.commands.CountdownCommand;
import org.lilbrocodes.theatrical.commands.DirectorCommand;
import org.lilbrocodes.theatrical.commands.argument_type.PlayerListArgumentSerializer;
import org.lilbrocodes.theatrical.commands.argument_type.PlayerListArgumentType;
import org.lilbrocodes.theatrical.commands.argument_type.PlotArmorArgumentType;
import org.lilbrocodes.theatrical.config.Configs;
import org.lilbrocodes.theatrical.mixin.accessor.HandHeldDataHolder;
import org.lilbrocodes.theatrical.mixin.accessor.WalkSpeedHolder;

public class Theatrical
implements ModInitializer {
    public static final String MOD_ID = "theatrical";
    public static final class_2960 COUNTDOWNS = Theatrical.identify("countdowns");
    public static final class_2960 COUNTDOWN_ATTEMPTS = Theatrical.identify("countdown_attempts");
    public static final class_2960 PLAYER_LIST = Theatrical.identify("player_list");
    public static final class_2960 PLOT_ARMOR_TYPE = Theatrical.identify("plot_armor_type");
    public static final class_2960 DIRECTOR_PACKET = Theatrical.identify("director");
    public static final class_2960 PLOT_ARMOR_PACKET = Theatrical.identify("plot_armor");
    public static final class_2960 HAND_HELD_PACKET = Theatrical.identify("hand_held_out");
    public static final class_2960 WALK_SPEED_PACKET = Theatrical.identify("walk_speed");
    public static final class_2960 TAKE_ITEM_PACKET = Theatrical.identify("take_item_c2s");
    public static final class_2960 START_COUNTDOWN_PACKET = Theatrical.identify("start_countdown");
    public static final class_2960 COUNTDOWN_PING_PACKET = Theatrical.identify("countdown_ping");
    public static final class_2960 COUNTDOWN_RESPONSE_PACKET = Theatrical.identify("countdown_response");

    public void onInitialize() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)PLAYER_LIST, PlayerListArgumentType.class, (class_2314)PlayerListArgumentSerializer.INSTANCE);
        ArgumentTypeRegistry.registerArgumentType((class_2960)PLOT_ARMOR_TYPE, PlotArmorArgumentType.class, (class_2314)class_2319.method_41999(PlotArmorArgumentType::plotArmor));
        CommandRegistrationCallback.EVENT.register(CountdownCommand::register);
        CommandRegistrationCallback.EVENT.register(DirectorCommand::register);
        Configs.initialize();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)COUNTDOWN_RESPONSE_PACKET, (server, player, handler, buf, responseSender) -> {
            ArrayList<Integer> state = new ArrayList<Integer>();
            for (int i = 0; i < 3; ++i) {
                state.add(buf.readInt());
            }
            ((CountdownAttemptHolderComponent)TheatricalCardinalComponents.COUNTDOWN_ATTEMPTS.get((Object)player.method_37908())).updatePlayerState(player.method_5667(), state);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)HAND_HELD_PACKET, (server, player, handler, buf, responseSender) -> {
            boolean held = buf.readBoolean();
            server.execute(() -> ((HandHeldDataHolder)player).theatrical$setHandHeldOut(held));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)WALK_SPEED_PACKET, (server, player, handler, buf, responseSender) -> {
            int value = buf.readInt();
            server.execute(() -> ((WalkSpeedHolder)player).theatrical$setWalkSpeed(value));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TAKE_ITEM_PACKET, (server, player, handler, buf, responseSender) -> {
            int targetId = buf.readInt();
            server.execute(() -> {
                class_1297 targetEntity = player.method_37908().method_8469(targetId);
                if (targetEntity instanceof class_1657) {
                    class_1657 targetPlayer = (class_1657)targetEntity;
                    HandHeldDataHolder targetHolder = (HandHeldDataHolder)targetPlayer;
                    HandHeldDataHolder requesterHolder = (HandHeldDataHolder)player;
                    double maxDistanceSq = 9.0;
                    if (player.method_5858((class_1297)targetPlayer) <= maxDistanceSq && targetHolder.theatrical$isHandHeldOut() && player.method_5998(class_1268.field_5808).method_7960() && !targetPlayer.method_5998(class_1268.field_5808).method_7960()) {
                        class_1799 item = targetPlayer.method_5998(class_1268.field_5808);
                        player.method_6122(class_1268.field_5808, item);
                        targetPlayer.method_6122(class_1268.field_5808, class_1799.field_8037);
                        player.method_37908().method_45447(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248);
                    } else {
                        requesterHolder.theatrical$setHandHeldOut(true);
                    }
                } else {
                    ((HandHeldDataHolder)player).theatrical$setHandHeldOut(true);
                }
            });
        });
    }

    public static class_2960 identify(String name) {
        return new class_2960(MOD_ID, name);
    }
}

