/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.theatrical.cca.world;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.lilbrocodes.theatrical.Theatrical;
import org.lilbrocodes.theatrical.cca.TheatricalCardinalComponents;
import org.lilbrocodes.theatrical.util.CountdownAttempt;

public class CountdownAttemptHolderComponent
implements ServerTickingComponent,
AutoSyncedComponent {
    private final class_1937 world;
    private final List<CountdownAttempt> holder = new ArrayList<CountdownAttempt>();

    public CountdownAttemptHolderComponent(class_1937 world) {
        this.world = world;
    }

    private void sync() {
        TheatricalCardinalComponents.COUNTDOWN_ATTEMPTS.sync((Object)this.world);
    }

    public void updatePlayerState(UUID uuid, List<Integer> state) {
        for (CountdownAttempt attempt : this.holder) {
            attempt.setState(uuid, state);
        }
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        class_2499 countdowns = new class_2499();
        for (CountdownAttempt attempt : this.holder) {
            countdowns.add((Object)attempt.writeToNbt(new class_2487()));
        }
        tag.method_10566("countdowns", (class_2520)countdowns);
    }

    public void readFromNbt(class_2487 tag) {
        this.holder.clear();
        class_2499 countdownTagList = tag.method_10554("countdowns", 10);
        for (class_2520 element : countdownTagList) {
            this.holder.add(CountdownAttempt.readFromNbt((class_2487)element));
        }
    }

    public void create(UUID owner, List<UUID> players, int duration) {
        this.holder.add(new CountdownAttempt(owner, players, duration, null));
        players.forEach(uuid -> ServerPlayNetworking.send((class_3222)((class_3222)this.world.method_18470(uuid)), (class_2960)Theatrical.COUNTDOWN_PING_PACKET, (class_2540)new class_2540(Unpooled.buffer())));
        this.sync();
    }

    public void serverTick() {
        this.holder.removeIf(attempt -> attempt.shouldRemove(this.world));
        this.sync();
    }
}

