/*
 * Decompiled with CFR 0.152.
 */
package com.rolikdev;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ChristmasSpirit
extends SwordItem {
    private static final Map<FireworkRocketEntity, Integer> fireworkTimers = new HashMap<FireworkRocketEntity, Integer>();

    public ChristmasSpirit(Tier p_43269_, Item.Properties p_43272_) {
        super(p_43269_, p_43272_);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level world = attacker.level();
        if (world.isClientSide()) {
            return super.hurtEnemy(stack, target, attacker);
        }
        world.playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.PLAYERS, 1.0f, 1.0f);
        ItemStack fireworkStack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        CompoundTag tag = new CompoundTag();
        CompoundTag fireworksTag = new CompoundTag();
        fireworksTag.putByte("Flight", (byte)5);
        ListTag explosions = new ListTag();
        CompoundTag explosion = new CompoundTag();
        explosion.putByte("Type", (byte)0);
        explosion.putIntArray("Colors", new int[]{0xFF0000, 0xFFFF00, 65280});
        explosions.add((Object)explosion);
        explosion.putBoolean("Flicker", true);
        explosion.putBoolean("Trail", true);
        fireworksTag.put("Explosions", (Tag)explosions);
        tag.put("Fireworks", (Tag)fireworksTag);
        FireworkRocketEntity firework = new FireworkRocketEntity(world, target.getX(), target.getY(), target.getZ(), fireworkStack);
        world.addFreshEntity((Entity)firework);
        Vec3 direction = attacker.getLookAngle();
        firework.setDeltaMovement(direction.normalize().scale(1.0));
        target.startRiding((Entity)firework, true);
        int particleCount = 20;
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (world.random.nextDouble() - 0.5) * (double)target.getBbWidth();
            double offsetY = world.random.nextDouble() * (double)target.getBbHeight();
            double offsetZ = (world.random.nextDouble() - 0.5) * (double)target.getBbWidth();
            int color = world.random.nextInt(3);
            world.addParticle((ParticleOptions)(switch (color) {
                case 0 -> new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
                case 1 -> new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f);
                default -> new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f);
            }), target.getX() + offsetX, target.getY() + offsetY, target.getZ() + offsetZ, 0.0, 0.0, 0.0);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            if (world.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7cAbility on cooldown!"), true);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!world.isClientSide) {
            player.getCooldowns().addCooldown((Item)this, 600);
            AABB area = player.getBoundingBox().inflate(32.0);
            List mobs = world.getEntitiesOfClass(Mob.class, area);
            for (Mob mob : mobs) {
                FireworkRocketEntity firework = new FireworkRocketEntity(world, mob.getX(), mob.getY(), mob.getZ(), new ItemStack((ItemLike)Items.FIREWORK_ROCKET));
                world.addFreshEntity((Entity)firework);
                mob.hurt(world.damageSources().fireworks(firework, (Entity)player), 2.5f);
                mob.startRiding((Entity)firework, true);
                for (int i = 0; i < 5; ++i) {
                    world.addParticle((ParticleOptions)ParticleTypes.FIREWORK, mob.getX(), mob.getY() + 1.0, mob.getZ(), (Math.random() - 0.5) * 0.2, Math.random() * 0.2, (Math.random() - 0.5) * 0.2);
                }
            }
            world.playSound(null, player.blockPosition(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

