/*
 * Decompiled with CFR 0.152.
 */
package com.rolikdev;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HallowenSpiritBlade
extends SwordItem {
    LivingEntity toAttack;

    public HallowenSpiritBlade(Tier p_43269_, Item.Properties p_43272_) {
        super(p_43269_, p_43272_);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level world = attacker.level();
        this.toAttack = target;
        if (!world.isClientSide()) {
            double radius = 128.0;
            AABB box = new AABB(target.getX() - radius, target.getY() - radius, target.getZ() - radius, target.getX() + radius, target.getY() + radius, target.getZ() + radius);
            List nearbyEntities = world.getEntitiesOfClass(LivingEntity.class, box, e -> !e.equals((Object)target) && !e.equals((Object)attacker) && e.isAlive());
            for (LivingEntity mob : nearbyEntities) {
                if (!(mob instanceof Mob)) continue;
                Mob mobEntity = (Mob)mob;
                mobEntity.setTarget(target);
            }
            int duration = 200;
            target.addEffect(new MobEffectInstance(MobEffects.DARKNESS, duration, 0, false, false));
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, duration, 1, false, true));
            target.addEffect(new MobEffectInstance(MobEffects.GLOWING, duration, 1, false, true));
            target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, duration, 1, false, true));
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.heal(3.0f);
            }
            for (int i = 0; i < 20; ++i) {
                double offsetX = (world.random.nextDouble() - 0.5) * 1.5;
                double offsetY = world.random.nextDouble() * 1.5;
                double offsetZ = (world.random.nextDouble() - 0.5) * 1.5;
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, target.getX() + offsetX, target.getY() + offsetY, target.getZ() + offsetZ, 0.0, 0.0, 0.0);
            }
            world.playSound(null, target.blockPosition(), SoundEvents.WITCH_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide() && this.toAttack != null) {
            Witch witch = (Witch)EntityType.WITCH.create(world);
            Witch witch2 = (Witch)EntityType.WITCH.create(world);
            Witch witch3 = (Witch)EntityType.WITCH.create(world);
            if (witch != null) {
                Vec3 look = player.getLookAngle().normalize().scale(2.0);
                witch.moveTo(player.getX() + look.x, player.getY(), player.getZ() + look.z, world.random.nextFloat() * 360.0f, 0.0f);
                witch2.moveTo(player.getX() + look.x, player.getY(), player.getZ() + look.z, world.random.nextFloat() * 360.0f, 0.0f);
                witch3.moveTo(player.getX() + look.x, player.getY(), player.getZ() + look.z, world.random.nextFloat() * 360.0f, 0.0f);
                witch.getPersistentData().putInt("blade_lifetime", 250);
                witch2.getPersistentData().putInt("blade_lifetime", 250);
                witch3.getPersistentData().putInt("blade_lifetime", 250);
                world.addFreshEntity((Entity)witch);
                world.addFreshEntity((Entity)witch2);
                world.addFreshEntity((Entity)witch3);
                if (this.toAttack != null) {
                    witch.setTarget(this.toAttack);
                    witch2.setTarget(this.toAttack);
                    witch3.setTarget(this.toAttack);
                    this.toAttack = null;
                }
            }
        }
        return super.use(world, player, hand);
    }
}

