/*
 * Decompiled with CFR 0.152.
 */
package com.rolikdev;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class IceSpikeBlade
extends SwordItem {
    public IceSpikeBlade(Tier p_43269_, Item.Properties p_43272_) {
        super(p_43269_, p_43272_);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level world = attacker.level();
        if (world.isClientSide()) {
            return super.hurtEnemy(stack, target, attacker);
        }
        BlockPos center = target.blockPosition();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos pos = center.offset(dx, dy, dz);
                    if (!world.getBlockState(pos).isAir()) continue;
                    world.setBlock(pos, Blocks.FROSTED_ICE.defaultBlockState(), 3);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.scheduleTick(pos, Blocks.FROSTED_ICE, 100);
                    }
                    List entities = world.getEntitiesOfClass(LivingEntity.class, new AABB(pos));
                    for (LivingEntity e : entities) {
                        if (e == target || e == attacker) continue;
                        DamageSource magicDamage = world.damageSources().freeze();
                        target.hurt(magicDamage, 12.0f);
                        e.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 160, 5));
                        e.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 160, 5));
                        int currentFrozen = e.getTicksFrozen();
                        e.setTicksFrozen(Math.min(currentFrozen + 10, 140));
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                        e.hurt(world.damageSources().magic(), 1.0f);
                    }
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }
}

