/*
 * Decompiled with CFR 0.152.
 */
package com.rolikdev;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MidasGauntlet
extends SwordItem {
    LivingEntity toAttack;

    public MidasGauntlet(Tier p_43269_, Item.Properties p_43272_) {
        super(p_43269_, p_43272_);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"\u00a76Midas Gauntlet").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.literal((String)"\u00a77Grants the ability to turn enemies into gold."));
        tooltip.add((Component)Component.literal((String)"\u00a7eHold Shift for more info...").withStyle(ChatFormatting.YELLOW));
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.literal((String)"\u00a7aRight-click to consume a Gold Ingot and gain:"));
            tooltip.add((Component)Component.literal((String)"\u00a7cStrength III, \u00a7bSpeed III, \u00a7aRegeneration III \u00a77for 1 minute"));
            tooltip.add((Component)Component.literal((String)"\u00a78Cooldown: 2000 ticks (100 seconds)"));
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        float maxHealth;
        float currentHealth;
        Level world = attacker.level();
        if (!world.isClientSide() && (currentHealth = target.getHealth()) / (maxHealth = target.getMaxHealth()) <= 0.25f) {
            target.hurt(world.damageSources().magic(), Float.MAX_VALUE);
            target.remove(Entity.RemovalReason.KILLED);
            ItemEntity drop = new ItemEntity(world, target.getX(), target.getY(), target.getZ(), new ItemStack((ItemLike)Items.GOLD_INGOT, 1));
            world.addFreshEntity((Entity)drop);
            world.playSound(null, target.blockPosition(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 1.2f);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack mainHandStack = player.getItemInHand(hand);
        ItemStack offhandStack = player.getOffhandItem();
        if (offhandStack.getItem() == Items.GOLD_INGOT) {
            if (!world.isClientSide) {
                offhandStack.shrink(1);
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 2));
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 2));
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 1200, 2));
                player.addEffect(new MobEffectInstance(MobEffects.GLOWING, 1200, 2));
                player.heal(2.0f);
                player.getCooldowns().addCooldown((Item)this, 2000);
                double radius = 64.0;
                for (Mob mob : world.getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate(radius))) {
                    mob.setTarget((LivingEntity)player);
                }
                world.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 1.2f);
                world.playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 0.8f);
                return InteractionResultHolder.success((Object)stack);
            }
            player.displayClientMessage((Component)Component.literal((String)"\u00a76You need a Gold Ingot to empower the Gauntlet!"), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

