/*
 * Decompiled with CFR 0.152.
 */
package com.rolikdev;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class SoulSlasher
extends SwordItem {
    public SoulSlasher(Tier p_43269_, Item.Properties p_43272_) {
        super(p_43269_, p_43272_);
    }

    private void applyForcedKnockback(LivingEntity target, double strength, LivingEntity attacker) {
        double dx = target.getX() - attacker.getX();
        double dz = target.getZ() - attacker.getZ();
        Vec3 direction = new Vec3(dx, 0.0, dz).normalize();
        target.setDeltaMovement(target.getDeltaMovement().add(direction.x * strength, 0.4, direction.z * strength));
        target.hasImpulse = true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (!(attacker instanceof Player)) {
            return false;
        }
        Player player = (Player)attacker;
        ServerLevel world = (ServerLevel)player.level();
        if (!world.isClientSide) {
            double offsetX = (2.0 + Math.random()) * (double)(Math.random() < 0.5 ? -3 : 3);
            double offsetZ = (2.0 + Math.random()) * (double)(Math.random() < 0.5 ? -3 : 3);
            double offsetY = (2.0 + Math.random()) * (double)(Math.random() < 0.5 ? -3 : 3);
            double newX = player.getX() + offsetX;
            double newZ = player.getZ() + offsetZ;
            double newY = player.getY();
            BlockPos below = new BlockPos((int)newX, (int)(newY - 3.0), (int)newZ);
            while (!world.getBlockState(below).isSolidRender((BlockGetter)world, below) && newY > 0.0) {
                below = new BlockPos((int)newX, (int)((newY -= 1.0) - 3.0), (int)newZ);
            }
            player.teleportTo(newX, newY, newZ);
            target.hurt(target.damageSources().generic(), 3.0f);
            player.heal(3.0f);
            double dx = target.getX() - player.getX();
            double dz = target.getZ() - player.getZ();
            double distance = Math.sqrt(dx * dx + dz * dz);
            if (distance > 0.0) {
                target.push(dx / distance * 0.5, 0.25, dz / distance * 0.5);
            }
            world.playSound(null, player.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 0.8f);
            world.sendParticles((ParticleOptions)ParticleTypes.PORTAL, target.getX() + offsetX, target.getY() + offsetY, target.getZ() + offsetZ, 10, 0.0, 0.0, 0.0, 0.01);
        }
        return true;
    }
}

