/*
 * Decompiled with CFR 0.152.
 */
package com.rolikdev;

import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ThunderBlade
extends SwordItem {
    public ThunderBlade(Tier p_43269_, Item.Properties p_43272_) {
        super(p_43269_, p_43272_);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ServerLevel serverLevel;
        LightningBolt lightning;
        Level level;
        if (!attacker.level().isClientSide && (level = attacker.level()) instanceof ServerLevel && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)(serverLevel = (ServerLevel)level))) != null) {
            lightning.moveTo(target.getX(), target.getY(), target.getZ());
            if (attacker instanceof Player) {
                ServerPlayer player = (ServerPlayer)attacker;
                lightning.setCause(player);
            }
            serverLevel.addFreshEntity((Entity)lightning);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide()) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            player.getCooldowns().addCooldown((Item)this, 250);
            AABB area = new AABB(player.blockPosition()).inflate(48.0);
            List targets = world.getEntitiesOfClass(LivingEntity.class, area, e -> e != player && e.isAlive());
            for (LivingEntity target : targets) {
                LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(world);
                if (lightning == null) continue;
                lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)target.blockPosition()));
                lightning.setCause((ServerPlayer)player);
                world.addFreshEntity((Entity)lightning);
            }
            world.playSound(null, player.blockPosition(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.PLAYERS, 2.0f, 1.0f);
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                player.displayClientMessage((Component)Component.literal((String)"\u26a1 The thunder strikes... \u26a1 "), true);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }
}

