/*
 * Decompiled with CFR 0.152.
 */
package com.rolikdev;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WhirlwindBlade
extends SwordItem {
    public WhirlwindBlade(Tier p_43269_, Item.Properties p_43272_) {
        super(p_43269_, p_43272_);
    }

    private void applyForcedKnockback(LivingEntity target, double strength, LivingEntity attacker) {
        double dx = target.getX() - attacker.getX();
        double dz = target.getZ() - attacker.getZ();
        Vec3 direction = new Vec3(dx, 0.0, dz).normalize();
        target.setDeltaMovement(target.getDeltaMovement().add(direction.x * strength, 0.4, direction.z * strength));
        target.hasImpulse = true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide()) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            player.getCooldowns().addCooldown((Item)this, 175);
            double radius = 64.0;
            AABB area = new AABB(player.blockPosition()).inflate(radius);
            List targets = world.getEntitiesOfClass(LivingEntity.class, area, e -> e != player && e.isAlive());
            for (LivingEntity target : targets) {
                Vec3 velocity = target.getDeltaMovement();
                target.setDeltaMovement(velocity.x + 3.0, velocity.y + 13.5, velocity.z - 3.0);
                target.hurt(world.damageSources().mobAttack((LivingEntity)player), 6.5f);
                target.hasImpulse = true;
                for (int i = 0; i < 200; ++i) {
                    double offsetX = (world.random.nextDouble() - 0.5) * 2.0;
                    double offsetY = world.random.nextDouble() * 2.0;
                    double offsetZ = (world.random.nextDouble() - 0.5) * 2.0;
                    world.addParticle((ParticleOptions)ParticleTypes.CLOUD, player.getX() + offsetX, player.getY() + offsetY, player.getZ() + offsetZ, 0.0, 1.2, 0.0);
                }
            }
            world.playSound(null, player.blockPosition(), SoundEvents.EVOKER_FANGS_ATTACK, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            Level level = attacker.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 targetPos = target.position();
                double radius = 2.5;
                int count = 20;
                for (int i = 0; i < count; ++i) {
                    double offsetX = (serverLevel.getRandom().nextDouble() - 0.5) * radius * 2.0;
                    double offsetY = serverLevel.getRandom().nextDouble() * 1.0;
                    double offsetZ = (serverLevel.getRandom().nextDouble() - 0.5) * radius * 2.0;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMALL_GUST, targetPos.x + offsetX, targetPos.y + offsetY, targetPos.z + offsetZ, 10, 0.0, 0.0, 0.0, 0.01);
                }
                double strength = 11.5;
                this.applyForcedKnockback(target, strength, attacker);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }
}

