/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.figure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.vermulst.multibreak.figure.Matrix4x4;
import me.vermulst.multibreak.figure.types.FigureType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.util.Vector;

public abstract class Figure {
    private final int width;
    private final int height;
    private final int depth;
    private int offSetWidth = 0;
    private int offSetHeight = 0;
    private int offSetDepth = 0;
    private short rotationWidth = 0;
    private short rotationHeight = 0;
    private short rotationDepth = 0;

    public Figure(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public abstract Set<Vector> getVectors(boolean var1);

    public abstract FigureType getFigureType();

    public Set<Vector> applyRotation(Set<Vector> vectors, Figure figure) {
        HashSet<Vector> rotatedVectors = new HashSet<Vector>();
        Matrix4x4 rotationMatrix = new Matrix4x4();
        rotationMatrix.setRotationX((double)figure.getRotationWidth() * (Math.PI / 180));
        rotationMatrix.setRotationY((double)figure.getRotationHeight() * (Math.PI / 180));
        rotationMatrix.setRotationZ((double)figure.getRotationDepth() * (Math.PI / 180));
        for (Vector vector : vectors) {
            rotationMatrix.transform(vector);
            vector.setX((float)Math.round(vector.getX()));
            vector.setY((float)Math.round(vector.getY()));
            vector.setZ((float)Math.round(vector.getZ()));
            rotatedVectors.add(new Vector((float)Math.round(vector.getX()), (float)Math.round(vector.getY()), (float)Math.round(vector.getZ())));
        }
        return rotatedVectors;
    }

    public void setOffsets(int offSetWidth, int offSetHeight, int offSetDepth) {
        this.offSetWidth = offSetWidth;
        this.offSetHeight = offSetHeight;
        this.offSetDepth = offSetDepth;
    }

    public void setRotations(short rotationWidth, short rotationHeight, short rotationDepth) {
        this.rotationWidth = rotationWidth;
        this.rotationHeight = rotationHeight;
        this.rotationDepth = rotationDepth;
    }

    public List<TextComponent> getLore() {
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        TextComponent widthC = Component.text((String)"Width: ", (TextColor)NamedTextColor.GRAY);
        TextComponent heightC = Component.text((String)"Height: ", (TextColor)NamedTextColor.GRAY);
        TextComponent depthC = Component.text((String)"Depth: ", (TextColor)NamedTextColor.GRAY);
        lore.add(Component.empty());
        lore.add((TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Size").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.UNDERLINED, true)).decoration(TextDecoration.BOLD, true)).build());
        lore.add((TextComponent)widthC.append((Component)Component.text((int)this.getWidth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)heightC.append((Component)Component.text((int)this.getHeight(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)depthC.append((Component)Component.text((int)this.getDepth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add(Component.empty());
        lore.add((TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Rotations").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.UNDERLINED, true)).build());
        lore.add((TextComponent)widthC.append((Component)Component.text((int)this.getRotationWidth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)heightC.append((Component)Component.text((int)this.getRotationHeight(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)depthC.append((Component)Component.text((int)this.getRotationDepth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add(Component.empty());
        lore.add((TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Offsets").color(TextColor.color((int)255, (int)255, (int)255))).decoration(TextDecoration.UNDERLINED, true)).build());
        lore.add((TextComponent)widthC.append((Component)Component.text((int)this.getOffSetWidth(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)heightC.append((Component)Component.text((int)this.getOffSetHeight(), (TextColor)NamedTextColor.YELLOW)));
        lore.add((TextComponent)depthC.append((Component)Component.text((int)this.getOffSetDepth(), (TextColor)NamedTextColor.YELLOW)));
        return lore;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getOffSetWidth() {
        return this.offSetWidth;
    }

    public int getOffSetHeight() {
        return this.offSetHeight;
    }

    public int getOffSetDepth() {
        return this.offSetDepth;
    }

    public short getRotationWidth() {
        return this.rotationWidth;
    }

    public short getRotationHeight() {
        return this.rotationHeight;
    }

    public short getRotationDepth() {
        return this.rotationDepth;
    }
}

