/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.figure.types;

import java.util.HashSet;
import java.util.Set;
import me.vermulst.multibreak.figure.FigureIterable;
import me.vermulst.multibreak.figure.types.FigureType;
import org.bukkit.util.Vector;

public class FigureCircle
extends FigureIterable {
    public FigureCircle(int width, int height, int depth) {
        super(width, height, depth);
    }

    @Override
    public Set<Vector> getVectors(boolean rotated) {
        Vector startPos = new Vector(this.getOffSetWidth(), this.getOffSetHeight(), this.getOffSetDepth());
        double a = (double)this.getWidth() / 2.0;
        double b = (double)this.getHeight() / 2.0;
        double c = (double)this.getDepth() / 2.0;
        int resolution = 30;
        double du = Math.PI * 2 / (double)(resolution - 1);
        double dv = Math.PI / (double)(resolution - 1);
        HashSet<Vector> boundingVectors = new HashSet<Vector>();
        for (int i = 0; i < resolution; ++i) {
            double u = (double)i * du;
            for (int j = 0; j < resolution; ++j) {
                double v = (double)j * dv;
                Vector vector2 = this.generateEllipsoidPoint(u, v, a, b, c);
                vector2.add(startPos);
                boundingVectors.add(vector2);
            }
        }
        Set<Vector> vectors = this.iterateOverBoundingBox(boundingVectors, rotated);
        vectors.removeIf(vector -> !this.isInsideEllipsoid((Vector)vector, a, b, c));
        return vectors;
    }

    private boolean isInsideEllipsoid(Vector vector, double a, double b, double c) {
        double z;
        double y;
        double x = vector.getX() / a;
        return x * x + (y = vector.getY() / b) * y + (z = vector.getZ() / c) * z <= 1.0;
    }

    private Vector generateEllipsoidPoint(double u, double v, double a, double b, double c) {
        double cu = Math.cos(u);
        double su = Math.sin(u);
        double cv = Math.cos(v);
        double sv = Math.sin(v);
        int x = (int)Math.round(a * cu * sv);
        int y = (int)Math.round(b * su * sv);
        int z = (int)Math.round(c * cv);
        return new Vector(x, y, z);
    }

    @Override
    public FigureType getFigureType() {
        return FigureType.CIRCULAR;
    }
}

